% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse.R
\name{EllipseFromCenterAndMatrix}
\alias{EllipseFromCenterAndMatrix}
\title{Ellipse from center and matrix}
\usage{
EllipseFromCenterAndMatrix(center, S)
}
\arguments{
\item{center}{a point, the center of the ellipse}

\item{S}{a positive symmetric matrix}
}
\value{
An \code{Ellipse} object.
}
\description{
Returns the ellipse of equation
\code{t(X-center) \%*\% S \%*\% (X-center) = 1}.
}
\examples{
ell <- Ellipse$new(c(2,3), 4, 2, 20)
S <- ell$matrix()
EllipseFromCenterAndMatrix(ell$center, S)
}
