% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rotation.R
\name{Rotation}
\alias{Rotation}
\title{R6 class representing a rotation}
\description{
A rotation is given by an angle (\code{theta}) and a center.
}
\examples{

## ------------------------------------------------
## Method `Rotation$new`
## ------------------------------------------------

Rotation$new(60, c(1,1))

## ------------------------------------------------
## Method `Rotation$getMatrix`
## ------------------------------------------------

R <- Rotation$new(60, c(1,1))
P <- c(1,5)
R$rotate(P)
R$getMatrix() \%*\% c(P,1)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{theta}}{get or set the angle of the rotation}

\item{\code{center}}{get or set the center}

\item{\code{degrees}}{get or set the \code{degrees} field}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Rotation-new}{\code{Rotation$new()}}
\item \href{#method-Rotation-print}{\code{Rotation$print()}}
\item \href{#method-Rotation-rotate}{\code{Rotation$rotate()}}
\item \href{#method-Rotation-transform}{\code{Rotation$transform()}}
\item \href{#method-Rotation-rotateCircle}{\code{Rotation$rotateCircle()}}
\item \href{#method-Rotation-transformCircle}{\code{Rotation$transformCircle()}}
\item \href{#method-Rotation-rotateEllipse}{\code{Rotation$rotateEllipse()}}
\item \href{#method-Rotation-transformEllipse}{\code{Rotation$transformEllipse()}}
\item \href{#method-Rotation-rotateLine}{\code{Rotation$rotateLine()}}
\item \href{#method-Rotation-transformLine}{\code{Rotation$transformLine()}}
\item \href{#method-Rotation-getMatrix}{\code{Rotation$getMatrix()}}
\item \href{#method-Rotation-asAffine}{\code{Rotation$asAffine()}}
\item \href{#method-Rotation-clone}{\code{Rotation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-new"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Rotation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$new(theta, center, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theta}}{a number, the angle of the rotation}

\item{\code{center}}{a point, the center of the rotation}

\item{\code{degrees}}{logical, whether \code{theta} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Rotation} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Rotation$new(60, c(1,1))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-print"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-print}{}}}
\subsection{Method \code{print()}}{
Show instance of a \code{Rotation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-rotate"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-rotate}{}}}
\subsection{Method \code{rotate()}}{
Rotate a point or several points.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$rotate(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or a two-column matrix of points, one point per row}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-transform}{}}}
\subsection{Method \code{transform()}}{
An alias of \code{rotate}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or a two-column matrix of points, one point per row}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-rotateCircle"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-rotateCircle}{}}}
\subsection{Method \code{rotateCircle()}}{
Rotate a circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$rotateCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-transformCircle"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-transformCircle}{}}}
\subsection{Method \code{transformCircle()}}{
An alias of \code{rotateCircle}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$transformCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-rotateEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-rotateEllipse}{}}}
\subsection{Method \code{rotateEllipse()}}{
Rotate an ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$rotateEllipse(ell)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ell}}{an \code{Ellipse} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{Ellipse} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-transformEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-transformEllipse}{}}}
\subsection{Method \code{transformEllipse()}}{
An alias of \code{rotateEllipse}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$transformEllipse(ell)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ell}}{an \code{Ellipse} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{Ellipse} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-rotateLine"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-rotateLine}{}}}
\subsection{Method \code{rotateLine()}}{
Rotate a line.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$rotateLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-transformLine"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-transformLine}{}}}
\subsection{Method \code{transformLine()}}{
An alias of \code{rotateLine}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$transformLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-getMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-getMatrix}{}}}
\subsection{Method \code{getMatrix()}}{
Augmented matrix of the rotation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$getMatrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 3x3 matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{R <- Rotation$new(60, c(1,1))
P <- c(1,5)
R$rotate(P)
R$getMatrix() \%*\% c(P,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-asAffine"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-asAffine}{}}}
\subsection{Method \code{asAffine()}}{
Convert the reference rotation to an \code{Affine} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$asAffine()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Rotation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Rotation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Rotation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
