% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw}
\alias{draw}
\alias{draw.Triangle}
\alias{draw.Circle}
\alias{draw.Arc}
\alias{draw.Ellipse}
\alias{draw.EllipticalArc}
\alias{draw.Line}
\title{Draw a geometric object}
\usage{
draw(x, ...)

\method{draw}{Triangle}(x, ...)

\method{draw}{Circle}(x, npoints = 100L, ...)

\method{draw}{Arc}(x, npoints = 100L, ...)

\method{draw}{Ellipse}(x, npoints = 100L, ...)

\method{draw}{EllipticalArc}(x, npoints = 100L, ...)

\method{draw}{Line}(x, ...)
}
\arguments{
\item{x}{geometric object (\code{Triangle}, \code{Circle}, \code{Line},
\code{Ellipse}, \code{Arc}, \code{EllipticalArc})}

\item{...}{arguments passed to \code{\link{lines}} for a \code{Triangle}
object, an \code{Arc} object or an \code{ElipticalArc} object,
to \code{\link{polypath}} for a \code{Circle} object or an
\code{Ellipse} object, general graphical parameters for a \code{Line}
object, passed to \code{\link{lines}}, \code{\link{curve}}, or
\code{\link{abline}}.}

\item{npoints}{integer, the number of points of the path}
}
\description{
Draw a geometric object on the current plot.
}
\examples{
# open new plot window
plot(0, 0, type="n", asp = 1, xlim = c(0,2.5), ylim = c(0,2.5),
     xlab = NA, ylab = NA)
grid()
# draw a triangle
t <- Triangle$new(c(0,0), c(1,0), c(0.5,sqrt(3)/2))
draw(t, col = "blue", lwd = 2)
draw(t$rotate(90, t$C), col = "green", lwd = 2)
# draw a circle
circ <- t$incircle()
draw(circ, col = "orange", border = "brown", lwd = 2)
# draw an ellipse
S <- Scaling$new(circ$center, direction = c(2,1), scale = 2)
draw(S$scaleCircle(circ), border = "grey", lwd = 2)
# draw a line
l <- Line$new(c(1,1), c(1.5,1.5), FALSE, TRUE)
draw(l, col = "red", lwd = 2)
perp <- l$perpendicular(c(2,1))
draw(perp, col = "yellow", lwd = 2)
}
