% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AxisScaling.R
\name{ScalingXY}
\alias{ScalingXY}
\title{R6 class representing an axis-scaling}
\description{
An axis-scaling is given by a center, and two scale factors
\code{sx} and \code{sy}, one for the x-axis and one for the y-axis.
}
\examples{

## ------------------------------------------------
## Method `ScalingXY$new`
## ------------------------------------------------

ScalingXY$new(c(1,1), 4, 2)

## ------------------------------------------------
## Method `ScalingXY$getMatrix`
## ------------------------------------------------

S <- ScalingXY$new(c(1,1), 4, 2)
P <- c(1,5)
S$transform(P)
S$getMatrix() \%*\% c(P,1)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{center}}{get or set the center}

\item{\code{sx}}{get or set the scale factor of the x-axis}

\item{\code{sy}}{get or set the scale factor of the y-ayis}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ScalingXY$new()}}
\item \href{#method-print}{\code{ScalingXY$print()}}
\item \href{#method-transform}{\code{ScalingXY$transform()}}
\item \href{#method-getMatrix}{\code{ScalingXY$getMatrix()}}
\item \href{#method-asAffine}{\code{ScalingXY$asAffine()}}
\item \href{#method-clone}{\code{ScalingXY$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{ScalingXY} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalingXY$new(center, sx, sy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{center}}{a point, the center of the scaling}

\item{\code{sx}}{a number, the scale factor of the x-axis}

\item{\code{sy}}{a number, the scale factor of the y-axis}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ScalingXY} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ScalingXY$new(c(1,1), 4, 2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Show instance of a \code{ScalingXY} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalingXY$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\subsection{Method \code{transform()}}{
Transform a point or several points by the reference axis-scaling.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalingXY$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or a two-column matrix of points, one point per row}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A point or a two-column matrix of points.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getMatrix"></a>}}
\subsection{Method \code{getMatrix()}}{
Augmented matrix of the axis-scaling.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalingXY$getMatrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 3x3 matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{S <- ScalingXY$new(c(1,1), 4, 2)
P <- c(1,5)
S$transform(P)
S$getMatrix() \%*\% c(P,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asAffine"></a>}}
\subsection{Method \code{asAffine()}}{
Convert the reference axis-scaling to an \code{Affine}
object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalingXY$asAffine()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScalingXY$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
