% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_phevis.R
\name{train_phevis}
\alias{train_phevis}
\title{train_phevis}
\usage{
train_phevis(
  half_life,
  df,
  START_DATE,
  PATIENT_NUM,
  ENCOUNTER_NUM,
  var_vec,
  main_icd,
  main_cui,
  rf = TRUE,
  p.noise = 0.3,
  bool_SAFE = TRUE,
  omega = 2,
  GS = NULL
)
}
\arguments{
\item{half_life}{Duration of cumulation. For a chronic disease you might chose Inf, for acute disease you might chose the duration of the disease.}

\item{df}{\code{data.frame} containing all the variables.}

\item{START_DATE}{Column name of the time column. The time column should be numeric}

\item{PATIENT_NUM}{Column name of the patient id column.}

\item{ENCOUNTER_NUM}{Column name of the encounter id column.}

\item{var_vec}{Explanatory variables used for the prediction, including the main variables.}

\item{main_icd}{Character vector of the column names of the main ICD codes.}

\item{main_cui}{Character vector of the column names of the main CUIs.}

\item{rf}{should pseudo-labellisation with random forest be used (default is true)}

\item{p.noise}{percentage of noise introduced during the noising step (default is 0.3)}

\item{bool_SAFE}{A boolean. If TRUE, SAFE selection is done, else it is not (default is TRUE)}

\item{omega}{Constant for the extrema population definition (default is 2)}

\item{GS}{Character string corresponding to the name of the gold-standard variable (default is null for which a vector of 0 will be taken).}
}
\value{
A list
\itemize{
 \item surparam - the parameters used to compute the surrogate
 \item model - the random intercept logistic regression
 \item df_train_result - the \code{data.frame} containing the output predictions
 \item train_param - parameters for the model training (variables used, main ICD and CUIS, half_life, gold standard)
}
}
\description{
Global function to train phevis model.
}
\examples{
\donttest{library(dplyr)
PheVis::data_phevis
df <- data_phevis \%>\%
         mutate(ENCOUNTER_NUM = row_number(),
         time = round(as.numeric(time)))
model <- PheVis::train_phevis(half_life = Inf,
         df = df,
         START_DATE = "time",
         PATIENT_NUM = "subject",
         ENCOUNTER_NUM = "ENCOUNTER_NUM",
         var_vec = c(paste0("var",1:10), "mainCUI", "mainICD"),
         main_icd = "mainICD",
         main_cui = "mainCUI")}

}
