% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RunAdaptiveEffToxTrialCORR}
\alias{RunAdaptiveEffToxTrialCORR}
\title{Simulates utility based Efftox trials}
\usage{
RunAdaptiveEffToxTrialCORR(DoseStart, Dose, Hypermeans, Hypervars, UT,
  PiLim, ProbLim, cohort, NET, NF, B, nSims, PMAT)
}
\arguments{
\item{DoseStart}{Dose level to START the EFF-Tox Trial}

\item{Dose}{Vector of Doses considered in the trial}

\item{Hypermeans}{6 vector of prior means}

\item{Hypervars}{6 vector of prior standard deviations}

\item{UT}{2x2 matrix of utilities corresponding to the four binary bivariate (toxicity, efficacy) events.}

\item{PiLim}{2 vector of acceptable limits}

\item{ProbLim}{2 vector of cutoff for acceptabilities}

\item{cohort}{Cohort size}

\item{NET}{Maximum Sample size to run the EFFtox Trial, must be divisible by cohort}

\item{NF}{Minimum sample size to begin adaptive randomization, must be divisible by count}

\item{B}{Number of reps to perform in MCMC}

\item{nSims}{Number of Simulated trials to run.}

\item{PMAT}{Contains TRUE pi00,pi10, pi01, pi11 for each dose}
}
\value{
Trial simulation results to be processed for operating characteristics summaries.
}
\description{
Simulates utility based Efftox trials
}
