% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{AssignEffToxUT}
\alias{AssignEffToxUT}
\title{Determines the optimal dose to assign the next patient cohort.}
\usage{
AssignEffToxUT(YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, UT,
  PiLim, ProbLim, B)
}
\arguments{
\item{YE}{Vector containing observed efficacy indicators.}

\item{YT}{Vector containing observed toxicity indicators.}

\item{Doses}{Vector containing numbered Doses of patients in trial.}

\item{Dose}{Vector containing the standardized doses considered.}

\item{DosesTried}{Binary vector corresponding to which doses have been tried.}

\item{Hypermeans}{Vector containing prior hypermeans of length 6 for Eff-Tox parameters.}

\item{Hypervars}{Vector containing prior hypervariances of length 6 for Eff-Tox parameters.}

\item{UT}{2x2 utility matrix.}

\item{PiLim}{Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.}

\item{ProbLim}{Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.}

\item{B}{Number of iterations to perform in the MCMC.}
}
\value{
The optimal dose level to administer the next patient cohort.
}
\description{
This function returns the optimal acceptable dose number to assign the next patient cohort or stops the trial if no dose is deemed acceptable.
}
