% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimSpsoUt.R
\name{SimSpsoUt}
\alias{SimSpsoUt}
\title{Simulates trial replications from the SPSO model with desirability optimality function.}
\usage{
SimSpsoUt(NSims, PE, PT, corET, Nmax, cohort, UT, CutE, CutT, AcceptE,
  AcceptT, HypermeansE, HypermeansT, Hypervars)
}
\arguments{
\item{NSims}{Number of trial simulations to run.}

\item{PE}{True efficacy probability for each dose.}

\item{PT}{True toxicity probaiblity for each dose.}

\item{corET}{Correlation parameter between efficacy and toxicity probability.}

\item{Nmax}{Maximum trial sample size.}

\item{cohort}{Patient cohort size.}

\item{UT}{Utility matrix for the four bivariate (efficacy, toxicity) events.}

\item{CutE}{Cutoff for efficacy probability acceptability. Dose-efficacy probabilities must be larger than this for patient assignment.}

\item{CutT}{Cutoff for toxicity probability acceptability. Dose-toxicity probabilities must be smaller than this for patient assignment.}

\item{AcceptE}{Posterior probability threshold for efficacy acceptability.}

\item{AcceptT}{Posterior probability threshold for toxicity acceptability.}

\item{HypermeansE}{Hypermeans for dose-specific efficacy parameters.}

\item{HypermeansT}{Hypermeans for dose-specific toxcity parameters.}

\item{Hypervars}{Hypervariances needed for the SPSO model. Contains, in order (sigma_0^2, sigma_mu^2,tau).}
}
\value{
A list with the first entry corresponding to a matrix with: (1) True toxicity probabilities at each dose, (2) True efficacy probabilities at each dose, (3) True mean utility of each dose, (4) Optimal dose selection probability, (5) Average sample size of patients treated at each dose. The second entry of the list contains a vector with rows corresponding to (1) the true binary bivariate correlation between efficacy and toxicity, (2) Stopping probability of the trial, (3) Average number of efficacy events, (4) Average number of toxicity events, and (5) Delta.
}
\description{
Simulates replications from a Bayesian adaptive phase 12 clinical trial design using the SPSO model and a optimality function based on the desirability tradeoff contour.
}
\examples{
library(mvtnorm)
##True toxicity probability
PT=c(.05,.10,.15,.20,.30)
##True Efficacy Probability
PE=c(.2,.4,.6,.65,.7)
#True Correlation
corET=.5
##Number of simulations
NSims=1 ##Increase this when using
##Hypermeans and hypervariances
HypermeansE=c(-1.189, -0.357,  0.360,  0.546,  0.743)
HypermeansT=c(-2.325, -1.811, -1.464, -1.189, -0.740)
Hypervars=c(1,16,1)
##Trial Parameters
##Cohort Size, N^F and N_ET
cohort=3
##Starting Dose
DoseStart=1
Nmax=30 ##Max Sample Size
#Acceptability Criterion
CutE=.3
CutT=.4
##Limits on acceptability
AcceptE=.1
AcceptT=.1
##UTILITY Matrix
UT = matrix(c(38.23529,100,0,61.76471),nrow=2,byrow=TRUE)
RESULTS=SimSpsoUt(NSims, PE, PT, corET, Nmax, cohort, UT,
CutE, CutT, AcceptE, AcceptT,HypermeansE, HypermeansT, Hypervars)
RESULTS
}
