% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{breed.list}
\alias{breed.list}
\title{Method for calling the 'breed.list' method of the Petfinder API. Returns the
available breeds for the selected animal.}
\usage{
breed.list(animal, return_df = TRUE)
}
\arguments{
\item{animal}{Return breeds of animal. Must be one of 'barnyard', 'bird',
'cat', 'dog', 'horse', 'reptile', or 'smallfurry'.}

\item{return_df}{If TRUE, the function will coerce the output JSON from the
Petfinder API into a data.frame}
}
\value{
List of returned JSON from the Petfinder API. If the parameter return_df 
  is TRUE, a data.frame is returned instead.
}
\description{
Method for calling the 'breed.list' method of the Petfinder API. Returns the
available breeds for the selected animal.
}
\examples{
\dontrun{
pf <- Petfinder(key) # Initialize Petfinder class
pf$breed.list('cat')
pf$breed.list('dog')
}
}
