% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_BTSPAS_est.R
\name{LP_BTSPAS_est}
\alias{LP_BTSPAS_est}
\title{Extract estimates of abundance after BTSPAS fit}
\usage{
LP_BTSPAS_est(LP_BTSPAS_fit, parm = "Ntot", conf_level = 0.95, trace = FALSE)
}
\arguments{
\item{LP_BTSPAS_fit}{A result of an call to fitting at BTSPAS object.}

\item{parm}{Which parameter from the BTSPAS fix is to be extracted?}

\item{conf_level}{The expected coverage for confidence intervals on N.}

\item{trace}{If trace flag is set in call when estimating functions}
}
\value{
An list object of class \emph{LP_BTSPAS_est} with the following elements
\itemize{
\item \strong{summary} A data frame  with the estimates of abundance, SE, and CI
\item \strong{datetime} Date and time the fit was done
}
}
\description{
This will take a previous fit and return estimates of abundance.
}
\examples{
\donttest{
# NOTE. To keep execution time to a small value as required by CRAN
# I've made a very small example.
# Additionally, I've set the number of MCMC chains, iterations, burning, simulation to save to
# small values. Proper mixing may not have occurred yet.
# When using this routine, you likely want to the use the default values
# for these MCMC parameters.

data(data_btspas_diag1)
# extract the strata of interest
temp<- cbind(data_btspas_diag1,
             split_cap_hist( data_btspas_diag1$cap_hist,
                             sep="..", make.numeric=TRUE))
# only use data up to week 10 to keep example small
temp <- temp[ temp$t1 \%in\% 0:10 & temp$t2 \%in\% 0:10,]

fit <- Petersen::LP_BTSPAS_fit_Diag(
  temp,
  p_model=~1,
  InitialSeed=23943242,
  # the number of chains and iterations are too small to be useful
  # they are set to a small number to pare execution time to <5 seconds for an example
  n.chains=2, n.iter=20000, n.burnin=1000, n.sims=100,
  quietly=TRUE
)
fit$summary

# now get the estimates of abundance
est <-  Petersen::LP_BTSPAS_est (fit)
est$summary
}


}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
