% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{distance}
\alias{distance}
\title{Compute the distance between permutations}
\usage{
distance(perm1, perm2 = identity.permutation(length(perm1)),
  dist.name = "kendall")
}
\arguments{
\item{perm1}{a permutation}

\item{perm2}{optional a permutation}

\item{dist.name}{optional. One of: kendall (default), cayley, hamming, ulam}
}
\value{
The distance between the permutations
}
\description{
Compute the distance between two given permutations. If only one permutation is 
given the other one is assumed to be the identity (1,2,3,....,n)
The distance can be kendall, cayley, hamming and ulam
}
\examples{
distance(c(1,2,3,5,4))
distance(c(1,2,3,5,4), c(1,2,3,5,4))
distance(c(1,2,3,5,4), c(1,4,2,3,5), "cayley")
}
