% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_sequence.R
\name{strip_sequence}
\alias{strip_sequence}
\title{Strip peptide sequences based on the specified data type}
\usage{
strip_sequence(data, column, convert_column, type)
}
\arguments{
\item{data}{A data frame with the peptide sequences.}

\item{column}{The name of the column containing the peptide sequences to be stripped.}

\item{convert_column}{The name of the column where the stripped sequences will be stored.}

\item{type}{A character string specifying the data type (e.g. 'Skyline' or 'Maxquant').}
}
\value{
A data frame with the specified column containing stripped sequences.
}
\description{
This function takes outputs from multiple platform, a data frame with a
column containing peptide sequences to be stripped,
and a column where the stripped sequences will be stored. The function chooses
the appropriate stripping method based on the specified data type ('PEAKS',
'Spectronaut', 'MSFragger', 'Comet', 'DIANN', 'Skyline' or 'Maxquant').
}
\examples{
library(data.table)
data_skyline <- data.table(
  'Peptide Modified Sequence' = c(
    "AGLC[+57]QTFVYGGC[+57]R",
    "AAAASAAEAGIATTGTEDSDDALLK",
    "IVGGWEC[+57]EK"
  ),
  Condition = c("A", "B", "B")
)
data_maxquant <- data.table(
  'Modified sequence' = c(
    "_(ac)AAAAELRLLEK_",
    "_EAAENSLVAYK_",
    "_AADTIGYPVM(ox)IRSAYALGGLGSGICPNK_"
  ),
  Condition = c("A", "B", "B")
)

converted_data_skyline <- strip_sequence(data_skyline,
                                         'Peptide Modified Sequence',
                                         'Sequence',
                                         "Skyline")
converted_data_maxquant <- strip_sequence(data_maxquant, 'Modified sequence',
                                          'Sequence', "Maxquant")

}
