% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIntersect.R
\name{addIntersect}
\alias{addIntersect}
\title{It creates columns to indicate overlap information between two tables
`r lifecycle::badge("deprecated")`}
\usage{
addIntersect(
  x,
  tableName,
  value,
  filterVariable = NULL,
  filterId = NULL,
  idName = NULL,
  window = list(c(0, Inf)),
  indexDate = "cohort_start_date",
  censorDate = NULL,
  targetStartDate = startDateColumn(tableName),
  targetEndDate = endDateColumn(tableName),
  order = "first",
  nameStyle = "{value}_{id_name}_{window_name}"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{tableName}{name of the cohort that we want to check for overlap.}

\item{value}{value of interest to add: it can be count, flag, date or time.}

\item{filterVariable}{the variable that we are going to use to filter (e.g.
cohort_definition_id).}

\item{filterId}{the value of filterVariable that we are interested in, it can
be a vector.}

\item{idName}{the name of each filterId, must have same length than
filterId.}

\item{window}{window to consider events of.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a date column of x.}

\item{targetStartDate}{date of reference in cohort table, either for start
(in overlap) or on its own (for incidence).}

\item{targetEndDate}{date of reference in cohort table, either for end
(overlap) or NULL (if incidence).}

\item{order}{last or first date to use for date/time calculations.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}
}
\value{
table with added columns with overlap information.
}
\description{
It creates columns to indicate overlap information between two tables
`r lifecycle::badge("deprecated")`
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()
result <- cdm$cohort1 \%>\%
  addIntersect(tableName = "cohort2", value = "date") \%>\%
  dplyr::collect()
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
