% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunMultiplePlp.R
\name{createModelDesign}
\alias{createModelDesign}
\title{Specify settings for developing a single model}
\usage{
createModelDesign(
  targetId = NULL,
  outcomeId = NULL,
  restrictPlpDataSettings = createRestrictPlpDataSettings(),
  populationSettings = createStudyPopulationSettings(),
  covariateSettings = FeatureExtraction::createDefaultCovariateSettings(),
  featureEngineeringSettings = NULL,
  sampleSettings = NULL,
  preprocessSettings = NULL,
  modelSettings = NULL,
  splitSettings = createDefaultSplitSetting(),
  runCovariateSummary = TRUE
)
}
\arguments{
\item{targetId}{The id of the target cohort that will be used for data extraction (e.g., the ATLAS id)}

\item{outcomeId}{The id of the outcome that will be used for data extraction (e.g., the ATLAS id)}

\item{restrictPlpDataSettings}{The settings specifying the extra restriction settings when extracting the data created using \code{createRestrictPlpDataSettings()}.}

\item{populationSettings}{The population settings specified by \code{createStudyPopulationSettings()}}

\item{covariateSettings}{The covariate settings, this can be a list or a single \code{'covariateSetting'} object.}

\item{featureEngineeringSettings}{Either NULL or an object of class \code{featureEngineeringSettings} specifying any feature engineering used during model development}

\item{sampleSettings}{Either NULL or an object of class \code{sampleSettings} with the over/under sampling settings used for model development}

\item{preprocessSettings}{Either NULL or an object of class \code{preprocessSettings} created using \code{createPreprocessingSettings()}}

\item{modelSettings}{The model settings such as \code{setLassoLogisticRegression()}}

\item{splitSettings}{The train/validation/test splitting used by all analyses created using \code{createDefaultSplitSetting()}}

\item{runCovariateSummary}{Whether to run the covariateSummary}
}
\value{
A list with analysis settings used to develop a single prediction model
}
\description{
Specify settings for developing a single model
}
\details{
This specifies a single analysis for developing as single model
}
\examples{
# L1 logistic regression model to predict the outcomeId 2 using the targetId 2
# with with default population, restrictPlp, split, and covariate settings
createModelDesign(
  targetId = 1,
  outcomeId = 2,
  modelSettings = setLassoLogisticRegression(seed=42),
  populationSettings = createStudyPopulationSettings(),
  restrictPlpDataSettings = createRestrictPlpDataSettings(),
  covariateSettings = FeatureExtraction::createDefaultCovariateSettings(),
  splitSettings = createDefaultSplitSetting(splitSeed = 42),
  runCovariateSummary = TRUE
)
}
