% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{GenPareto_ML_Estimator_Alpha}
\alias{GenPareto_ML_Estimator_Alpha}
\title{Maximum Likelihood Estimation of the Pareto Alphas of a Generalized Pareto Distribution}
\usage{
GenPareto_ML_Estimator_Alpha(
  losses,
  t,
  truncation = NULL,
  reporting_thresholds = NULL,
  is.censored = NULL,
  weights = NULL,
  alpha_min = 0.001,
  alpha_max = 10
)
}
\arguments{
\item{losses}{Numeric vector. Losses that are used for the ML estimation.}

\item{t}{Numeric or numeric vector. Threshold of the generalized Pareto distribution. Alternatively, \code{t} can be a vector of same length as \code{losses}. In this case \code{t[i]} is the reporting threshold of \code{losses[i]}.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the generalized Pareto distribution is truncated at \code{truncation}.}

\item{reporting_thresholds}{Numeric vector. Allows to enter loss specific reporting thresholds. If \code{NULL} then all reporting thresholds are assumed to be less than or equal to \code{t}.}

\item{is.censored}{Logical vector. \code{TRUE} indicates that a loss has been censored by the policy limit. The assumption is that the uncensored losses are Generalized Pareto distributed with the alphas we are looking for. \code{is.censored = NULL} means that no losses are censored.}

\item{weights}{Numeric vector. Weights for the losses. For instance \code{weights[i] = 2} and \code{weights[j] = 1} for \code{j != i} has the same effect as adding another loss of size \code{loss[i]}.}

\item{alpha_min}{Numeric. Lower bound for the estimated alphas.}

\item{alpha_max}{Numeric. Upper bound for the estimated alphas.}
}
\value{
Maximum likelihood estimator for the parameters \code{alpha_ini} and \code{alpha_tail} of a generalized Pareto distribution with threshold \code{t} given the observations \code{losses}
}
\description{
Calculates the maximum likelihood estimators of the parameters alpha_ini and alpha_tail of a generalized Pareto distribution
with known threshold and (if applicable) known truncation
}
\examples{
losses <- rGenPareto(1000, 1000, 2,3)
GenPareto_ML_Estimator_Alpha(losses, 1000)
losses <- rGenPareto(1000, 1000, 2, 1, truncation = 10000)
GenPareto_ML_Estimator_Alpha(losses, 1000)
GenPareto_ML_Estimator_Alpha(losses, 1000, truncation = 10000)

t <- 1000
alpha_ini <- 1
alpha_tail <- 3
losses <- rGenPareto(5000, t, alpha_ini, alpha_tail)
reporting_thresholds <- rPareto(5000, 1000, 3)
reported <- losses > reporting_thresholds
losses <- losses[reported]
reporting_thresholds <- reporting_thresholds[reported]
GenPareto_ML_Estimator_Alpha(losses, t)
GenPareto_ML_Estimator_Alpha(losses, t, reporting_thresholds = reporting_thresholds)
limit <- 3000
censored <- losses > limit
losses[censored] <- limit
reported <- losses > reporting_thresholds
losses <- losses[reported]
censored <- censored[reported]
reporting_thresholds <- reporting_thresholds[reported]
GenPareto_ML_Estimator_Alpha(losses, t, reporting_thresholds = reporting_thresholds)
GenPareto_ML_Estimator_Alpha(losses, t, reporting_thresholds = reporting_thresholds,
                             is.censored = censored)

losses <- c(190, 600, 120, 270, 180, 120)
w <- rep(1, length(losses))
w[1] <- 3
losses2 <- c(losses, losses[1], losses[1])
GenPareto_ML_Estimator_Alpha(losses, 100, weights = w)
GenPareto_ML_Estimator_Alpha(losses2, 100)
}
