% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Fit_PML_Curve}
\alias{Fit_PML_Curve}
\title{Fits a Collective Model to a PML Curve}
\usage{
Fit_PML_Curve(
  return_periods,
  amounts,
  tail_alpha = 2,
  truncation = NULL,
  truncation_type = "lp",
  dispersion = 1
)
}
\arguments{
\item{return_periods}{Numeric vector. Vector containing the return periods of the PML curve.}

\item{amounts}{Numeric vector. Vector containing the loss amounts corresponding to the return periods.}

\item{tail_alpha}{Numerical. Pareto alpha that is used above the highest amount of the PML curve.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > max(t)}, then the distribution is truncated at \code{truncation}.}

\item{truncation_type}{Character. If \code{truncation_type = "wd"} then the whole distribution is truncated. If \code{truncation_type = "lp"} then a truncated Pareto is used for the last piece.}

\item{dispersion}{Numerical. Dispersion of the claim count distribution in the resulting PPP_Model.}
}
\value{
A PPP_Model object that contains the information about a collective model with a Panjer distributed claim count and a Piecewise Pareto distributed severity. The object contains the following elements: \itemize{
\item \code{FQ} Numerical. Frequency in excess of the lowest threshold of the piecewise Pareto distribution
\item \code{t} Numeric vector. Vector containing the thresholds for the piecewise Pareto distribution
\item \code{alpha} Numeric vector. Vector containing the Pareto alphas of the piecewise Pareto distribution
\item \code{truncation} Numerical. If \code{truncation} is not \code{NULL} and \code{truncation > max(t)}, then the distribution is truncated at \code{truncation}.
\item \code{truncation_type} Character. If \code{truncation_type = "wd"} then the whole distribution is truncated. If \code{truncation_type = "lp"} then a truncated Pareto is used for the last piece.
\item \code{dispersion} Numerical. Dispersion of the Panjer distribution (i.e. variance to mean ratio).
\item \code{Status} Numerical indicator: 0 = success, 1 = some information has been ignored, 2 = no solution found
\item \code{Comment} Character. Information on whether the fit was successful
}
}
\description{
Fits a PPP_Model that matches the values of a PML curve
}
\examples{
return_periods <- c(1, 5, 10, 20, 50, 100)
amounts <- c(1000, 4000, 7000, 10000, 13000, 14000)

fit <- Fit_PML_Curve(return_periods, amounts)
1 / Excess_Frequency(fit, amounts)

fit <- Fit_PML_Curve(return_periods, amounts, tail_alpha = 1.5,
                     truncation = 20000, truncation_type = "wd")
1 / Excess_Frequency(fit, amounts)

}
