% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{dPareto}
\alias{dPareto}
\title{Density of the Pareto Distribution}
\usage{
dPareto(x, t, alpha, truncation = NULL)
}
\arguments{
\item{x}{Numeric. The function evaluates the density at x.}

\item{t}{Numeric. Threshold of the Pareto distribution.}

\item{alpha}{Numeric. Pareto alpha.}

\item{truncation}{Numeric. If truncation is not NULL and truncation > t, then the Pareto distribution is truncated at truncation.}
}
\value{
Density function of the Pareto distribution with parameters \code{t} and \code{alpha} evaluated at \code{x}
}
\description{
Calculates the density function of the Pareto distribution
}
\examples{
x <- 0:10 * 1000
dPareto(x, 1000, 2)
dPareto(x, 1000, 2, truncation = 5000)

}
