\name{addOptPathEl}
\alias{addOptPathEl}
\title{Add a new element to an optimization path.}
\usage{
  addOptPathEl(op, x, y, dob = getOptPathLength(op) + 1L,
    eol = as.integer(NA),
    check.feasible = !op$add.transformed.x)
}
\arguments{
  \item{op}{[\code{\link{OptPath}}] \cr Optimization path.}

  \item{x}{[\code{list}]\cr List of parameter values for a
  point in input space. Must be in same order as
  parameters.}

  \item{y}{[\code{numeric}]\cr Vector of fitness values.
  Must be in same order as \code{y.names}.}

  \item{dob}{[\code{integer(1)}]\cr Date of birth of the
  new parameters.  Default is length of path + 1.}

  \item{eol}{[\code{integer(1)}]\cr End of life of point.
  Default is \code{NA}.}

  \item{check.feasible}{[\code{logical(1)}]\cr Should
  \code{x} be checked with \code{\link{isFeasible}}?
  Default is \code{TRUE}.}
}
\value{
  Nothing.
}
\description{
  Changes the argument in-place. Note that when adding
  parameters that have associated tranformations, it is
  probably best to add the untransformed values to the
  path. Otherwise you have to switch off the feasibility
  check, as constraints might now not hold anymore.
}
\examples{
ps <- makeParamSet(
  makeNumericParam("p1"),
  makeDiscreteParam("p2", values=c("a", "b"))
)
op <- makeOptPathDF(par.set=ps, y.names="y", minimize=TRUE)
addOptPathEl(op, x=list(p1=7, p2="b"), y=1)
addOptPathEl(op, x=list(p1=-1, p2="a"), y=2)
as.data.frame(op)
}

