% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appenders.R
\name{createEmailAppender}
\alias{createEmailAppender}
\title{Create e-mail appender}
\usage{
createEmailAppender(
  layout = layoutEmail,
  mailSettings,
  label = Sys.info()["nodename"],
  test = FALSE
)
}
\arguments{
\item{layout}{The layout to be used by the appender.}

\item{mailSettings}{Arguments to be passed to the \code{sendmail} function in the \code{sendmailR} package (except
subject and msg).}

\item{label}{A label to be used in the e-mail subject to identify a run. By default the
name of the computer is used.}

\item{test}{If TRUE, a message will be displayed on the console instead of sending an
e-mail.}
}
\description{
Create e-mail appender
}
\details{
Creates an appender that will send log events to an e-mail address using the \code{sendmailR} package.
Please make sure your settings are correct by using the \code{sendmailR} package before using those settings
here. \code{ParallelLogger} will not display any messages if something goes wrong when sending the e-mail.
}
\section{Using GMail}{


To use a GMail account, make sure to enable 2-step verification on your 
Google account (see 'Security'). Click on 2-Step Verification, and 
scroll down to 'App passwords'. Here, you can create an app-specific password
to be used with \code{ParallelLogger}. You can set 
\code{host.name = "smtp.gmail.com:587"}, and be sure to use 
\code{engine = "curl"}.
}

\examples{
mailSettings <- list(
  from = "someone@gmail.com",
  to = "someone_else@gmail.com",
  engine = "curl",
  engineopts  = list(
    username = "someone@gmail.com",
    password = "Secret!"
  ), 
  control = list(
    host.name = "smtp.gmail.com:587"
  )
)
# Setting test to TRUE in this example so we don't really send an e-mail:
appender <- createEmailAppender(
  layout = layoutEmail,
  mailSettings = mailSettings,
  label = "My R session",
  test = TRUE
)

logger <- createLogger(name = "EMAIL", threshold = "FATAL", appenders = list(appender))
registerLogger(logger)

logFatal("Something bad")

unregisterLogger("EMAIL")
}
