% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{placeboTest}
\alias{placeboTest}
\title{placeboTest}
\usage{
placeboTest(
  pm.obj,
  data.in,
  lag.in = NULL,
  number.iterations = 1000,
  confidence.level = 0.95,
  plot = FALSE,
  ...
)
}
\arguments{
\item{pm.obj}{an object of class \code{PanelMatch}}

\item{data.in}{data.frame with the original data}

\item{lag.in}{integer indicating earliest the time period(s) in the future for which the placebo test change in outcome will be calculated. Calculations will be made over the period t - max(lag) to t-2, where t is the time of treatment. The results are similar to those returned by PanelEstimate, except t-1 is used as the period of comparison, rather than the lead window.}

\item{number.iterations}{integer specifying the number of bootstrap iterations}

\item{confidence.level}{confidence level for the calculated standard error intervals}

\item{plot}{logical indicating whether or not a plot should be generated, or just return the raw data from the calculations}

\item{...}{extra arguments to be passed to plot}
}
\value{
list with 2 elements: "estimates", which contains the point estimates for the test and "bootstrapped.estimates", containing the bootstrapped point estimates for the test for each specified lag window period.
}
\description{
Calculates results for a placebo test
}
\details{
Calculate the results of a placebo test, looking at the change in outcome at time = t-1, compared to other pre-treatment periods in the lag window.
}
\examples{
PM.results <- PanelMatch(lag = 4, time.id = "year", unit.id = "wbcode2",
                         treatment = "dem", refinement.method = "mahalanobis",
                         data = dem, match.missing = TRUE,
                         covs.formula = ~ I(lag(tradewb, 1:4)),
                         size.match = 5, qoi = "att",
                         outcome.var = "y", lead = 0:4, forbid.treatment.reversal = FALSE,
                         placebo.test = TRUE)
placeboTest(PM.results, data.in = dem, number.iterations = 100, plot = FALSE)


}
