#' @title Multiple Indicator Cluster Survey (MICS) 2018 Child Questionnaire Data for Punjab, Pakistan
#' @name  PakPMICS2018mn
#' @description \code{PakPMICS2018mn} data of Child questionnaire, MICS Punjab, 2014.
#' @format A data frame with 157899 rows and 62 variables:
#' \describe{
#'    \item{\code{HH1}}{Cluster number}
#'    \item{\code{HH2}}{Household number}
#'    \item{\code{MWM1}}{Cluster number}
#'    \item{\code{MWM2}}{Household number}
#'    \item{\code{MWMINT}}{Interviewer number}
#'    \item{\code{MWM3}}{Man's line number}
#'    \item{\code{LN}}{Line number}
#'    \item{\code{MWM4}}{Supervisor's number}
#'    \item{\code{MWM5}}{Interviewer's number}
#'    \item{\code{MWM6D}}{Day of interview}
#'    \item{\code{MWM6M}}{Month of interview}
#'    \item{\code{MWM6Y}}{Year of interview}
#'    \item{\code{MWM8}}{Household interviewer}
#'    \item{\code{MWM9}}{Consent}
#'    \item{\code{MWM17}}{Result of man's interview}
#'    \item{\code{MWM7H}}{Start of interview - Hour}
#'    \item{\code{MWM7M}}{Start of interview - Minutes}
#'    \item{\code{MWM10H}}{End of interview - Hour}
#'    \item{\code{MWM10M}}{End of interview - Minutes}
#'    \item{\code{MWM11}}{Interview completed in private}
#'    \item{\code{MWM12}}{Language of the Questionnaire}
#'    \item{\code{MWM13}}{Language of the Interview}
#'    \item{\code{MWM14}}{Native language of the Respondent}
#'    \item{\code{MWM15}}{Translator used}
#'    \item{\code{MWMHINT}}{Household interviewer}
#'    \item{\code{MWB1}}{Check: Respondent to HH questionnaire}
#'    \item{\code{MWB2}}{Check: Highest level of school attended}
#'    \item{\code{MWB3M}}{Month of birth of man}
#'    \item{\code{MWB3Y}}{Year of birth of man}
#'    \item{\code{MWB4}}{Age of man}
#'    \item{\code{MWB5}}{Ever attended school}
#'    \item{\code{MWB6A}}{Highest level of school attended}
#'    \item{\code{MWB6B}}{Highest grade attended at that level}
#'    \item{\code{MWB7}}{Grade completion}
#'    \item{\code{MWB9}}{Attended school during current school year}
#'    \item{\code{MWB10A}}{Level of education attended current school year}
#'    \item{\code{MWB10B}}{Grade of education attended current school year}
#'    \item{\code{MWB11}}{Attended school previous school year}
#'    \item{\code{MWB12A}}{Level of education attended previous school year}
#'    \item{\code{MWB12B}}{Grade of education attended previous school year}
#'    \item{\code{MWB14}}{Can read part of the sentence}
#'    \item{\code{MWB15}}{Duration of living in current place}
#'    \item{\code{MWB16}}{Place of living prior to moving to current place}
#'    \item{\code{MWB17}}{Region prior to moving to current place}
#'    \item{\code{MWB18}}{Covered by health insurance}
#'    \item{\code{MWB19A}}{Type of health insurance: Public health organization}
#'    \item{\code{MWB19B}}{Type of health insurance: Health insurance through employer}
#'    \item{\code{MWB19C}}{Type of health insurance: Social security}
#'    \item{\code{MWB19D}}{Type of health insurance: Other privately purchased commercial health insurance}
#'    \item{\code{MWB19X}}{Type of health insurance: Other}
#'    \item{\code{MWB19NR}}{Type of health insurance: Missing}
#'    \item{\code{MWDOI}}{Date of interview man (CMC)}
#'    \item{\code{MWB1C}}{Date of birth of man (CMC)}
#'    \item{\code{MWB1F}}{Date flag for WB1}
#'    \item{\code{MWB2C}}{Age of respondent (calculated)}
#'    \item{\code{MWAGE}}{Age}
#'    \item{\code{MMT1}}{Frequency of reading newspaper or magazine}
#'    \item{\code{MMT2}}{Frequency of listening to the radio}
#'    \item{\code{MMT3}}{Frequency of watching TV}
#'    \item{\code{MMT4}}{Ever used a computer or a tablet}
#'    \item{\code{MMT5}}{Computer / tablet usage in the last 3 months}
#'    \item{\code{MMT6A}}{During the last 3 months: Copy or move a file or folder}
#'    \item{\code{MMT6B}}{During the last 3 months: Use a copy / paste in document}
#'    \item{\code{MMT6C}}{During the last 3 months: Send e-mail with attached file}
#'    \item{\code{MMT6D}}{During the last 3 months: Use a basic arithmetic formula in a  spreadsheet}
#'    \item{\code{MMT6E}}{During the last 3 months: Connect and install a new device}
#'    \item{\code{MMT6F}}{During the last 3 months: Install and configure software}
#'    \item{\code{MMT6G}}{During the last 3 months: Create an electronic presentation}
#'    \item{\code{MMT6H}}{During the last 3 months: Transfer a file}
#'    \item{\code{MMT6I}}{During the last 3 months: Write a computer program}
#'    \item{\code{MMT9}}{Ever used internet}
#'    \item{\code{MMT10}}{Internet usage in the last 3 months}
#'    \item{\code{MMT11}}{Own a mobile phone}
#'    \item{\code{MMT12}}{Mobile phone usage in the last 3 months}
#'    \item{\code{MCM1}}{Ever fathered any childeren}
#'    \item{\code{MCM2}}{Any sons or daughters living with you}
#'    \item{\code{MCM3}}{Sons living with you}
#'    \item{\code{MCM4}}{Daughters living with you}
#'    \item{\code{MCM5}}{Any sons or daughters not living with you}
#'    \item{\code{MCM6}}{Sons living elsewhere}
#'    \item{\code{MCM7}}{Daughters living elsewhere}
#'    \item{\code{MCM8}}{Ever had child who later died}
#'    \item{\code{MCM9}}{Boys dead}
#'    \item{\code{MCM10}}{Girls dead}
#'    \item{\code{MCM11}}{Children ever born}
#'    \item{\code{MCM12}}{Confirm total number of ever born}
#'    \item{\code{MCM15}}{Same biological mother}
#'    \item{\code{MCM16}}{Number of women respondent fathered children with}
#'    \item{\code{MCM17}}{Age when first child was born}
#'    \item{\code{MCM18M}}{Month of last birth}
#'    \item{\code{MCM18Y}}{Year of last birth}
#'    \item{\code{MDV1A}}{If she goes out with out telling husband: wife beating justified}
#'    \item{\code{MDV1B}}{If she neglects the children: wife beating justified}
#'    \item{\code{MDV1C}}{If she argues with husband: wife beating justified}
#'    \item{\code{MDV1D}}{If she refuses sex with husband: wife beating justified}
#'    \item{\code{MDV1E}}{If she burns the food: wife beating justified}
#'    \item{\code{MVT1}}{Something taken by using force or someone threatening to use force}
#'    \item{\code{MVT2}}{Victimisation happened during the last 12 months}
#'    \item{\code{MVT3}}{Number of times victimisation happened in the last year}
#'    \item{\code{MVT5}}{The last time that this happened, was anything stolen}
#'    \item{\code{MVT6}}{Person(s) had a weapon}
#'    \item{\code{MVT7A}}{Offender(s) had a knife, a gun or something else used as a weapon: A knife}
#'    \item{\code{MVT7B}}{Offender(s) had a knife, a gun or something else used as a weapon: A gun}
#'    \item{\code{MVT7X}}{Offender(s) had a knife, a gun or something else used as a weapon: Other weapon}
#'    \item{\code{MVT7NR}}{Offender(s) had a knife, a gun or something else used as a weapon: Missing}
#'    \item{\code{MVT8}}{Incident reported to the police}
#'    \item{\code{MVT9}}{Physically attacked}
#'    \item{\code{MVT10}}{Attack happened during the last 12 months}
#'    \item{\code{MVT11}}{Number of times attack happened in the last year}
#'    \item{\code{MVT12}}{Place attack happened the last time}
#'    \item{\code{MVT13}}{Number of people involved in committing the offence}
#'    \item{\code{MVT14}}{At least one of the offender(s) recognized at the time of the incident}
#'    \item{\code{MVT17}}{Person(s) had a weapon}
#'    \item{\code{MVT18A}}{Offender(s) had a knife, a gun or something else used as a weapon: A knife}
#'    \item{\code{MVT18B}}{Offender(s) had a knife, a gun or something else used as a weapon: A gun}
#'    \item{\code{MVT18X}}{Offender(s) had a knife, a gun or something else used as a weapon: Other weapon}
#'    \item{\code{MVT18NR}}{Offender(s) had a knife, a gun or something else used as a weapon: Missing}
#'    \item{\code{MVT19}}{Incident reported to the police}
#'    \item{\code{MVT20}}{Feeling safe walking alone in neighbourhood after dark}
#'    \item{\code{MVT21}}{Feeling safe at home alone after dark}
#'    \item{\code{MVT22A}}{In the past 12 months, felt discriminated: Ethnic or immigration origin}
#'    \item{\code{MVT22B}}{In the past 12 months, felt discriminated: Gender}
#'    \item{\code{MVT22C}}{In the past 12 months, felt discriminated: Sexual orientation}
#'    \item{\code{MVT22D}}{In the past 12 months, felt discriminated: Age}
#'    \item{\code{MVT22E}}{In the past 12 months, felt discriminated: Religion or belief}
#'    \item{\code{MVT22F}}{In the past 12 months, felt discriminated: Disability}
#'    \item{\code{MVT22X}}{In the past 12 months, felt discriminated: any other reason}
#'    \item{\code{MMA1}}{Currently married}
#'    \item{\code{MMA3}}{More than one wives}
#'    \item{\code{MMA4}}{Number of wives}
#'    \item{\code{MMA5}}{Ever married}
#'    \item{\code{MMA6}}{Marital status}
#'    \item{\code{MMA7}}{Married with someone once or more than once}
#'    \item{\code{MMA8M}}{Month of first marriage}
#'    \item{\code{MMA8Y}}{Year of first marriage}
#'    \item{\code{MMA11}}{Age at first marriage}
#'    \item{\code{MHA1}}{Ever heard of HIV or AIDS}
#'    \item{\code{MHA2}}{Can avoid HIV by having one uninfected partner}
#'    \item{\code{MHA3}}{Can get HIV from mosquito bites}
#'    \item{\code{MHA4}}{Can avoid HIV by using a condom correctly every time}
#'    \item{\code{MHA5}}{Can get HIV by sharing food with a person who has HIV}
#'    \item{\code{MHA6}}{Can get HIV through supernatural means}
#'    \item{\code{MHA7}}{Healthy-looking person may have HIV}
#'    \item{\code{MHA8A}}{HIV from mother to child during pregnancy}
#'    \item{\code{MHA8B}}{HIV from mother to child during delivery}
#'    \item{\code{MHA8C}}{HIV from mother to child through breastfeeding}
#'    \item{\code{MHA10}}{Aware of drugs used to reduce the risk of transmission to the baby}
#'    \item{\code{MHA24}}{Ever been tested for HIV}
#'    \item{\code{MHA25}}{Most recent time of testing for HIV}
#'    \item{\code{MHA26}}{Received results of HIV test}
#'    \item{\code{MHA27}}{Know a place to get HIV test}
#'    \item{\code{MHA28}}{Heard of test kit for HIV testing}
#'    \item{\code{MHA29}}{Ever tested yourself using test kit}
#'    \item{\code{MHA30}}{Would buy fresh vegetables from shopkeeper with AIDS virus}
#'    \item{\code{MHA31}}{Children living with HIV should be allowed to attend school with other children}
#'    \item{\code{MHA32}}{People hesitate to take an HIV test because they are afraid of how other people will react if the test result is positive}
#'    \item{\code{MHA33}}{People talk badly about people living with HIV, or who are thought to be living with HIV}
#'    \item{\code{MHA34}}{People living with HIV, or thought to be living with HIV, lose the respect of other people}
#'    \item{\code{MHA35}}{Agreement with the following statement: I would be ashamed if someone in my family had HIV}
#'    \item{\code{MHA36}}{Fear of getting HIV in contact with the saliva of a person living with HIV}
#'    \item{\code{MTA1}}{Ever tried cigarette smoking}
#'    \item{\code{MTA2}}{Age when cigarette was smoked for the first time}
#'    \item{\code{MTA3}}{Currently smoking cigarettes}
#'    \item{\code{MTA4}}{Number of cigarettes smoked in the last 24 hours}
#'    \item{\code{MTA5}}{Number of days when cigarettes were smoked in past month}
#'    \item{\code{MTA6}}{Ever tried any smoked tobacco products other than cigarettes}
#'    \item{\code{MTA7}}{Used any smoked tobacco products during the last month}
#'    \item{\code{MTA8A}}{Type of smoked tobacco product: Cigars}
#'    \item{\code{MTA8B}}{Type of smoked tobacco product: Water pipe}
#'    \item{\code{MTA8C}}{Type of smoked tobacco product: Cigarillos}
#'    \item{\code{MTA8D}}{Type of smoked tobacco product: Pipe/SHESHA}
#'    \item{\code{MTA8X}}{Type of smoked tobacco product: Other}
#'    \item{\code{MTA8NR}}{Type of smoked tobacco product: No response}
#'    \item{\code{MTA9}}{Number of days when tobacco products where smoked in past month}
#'    \item{\code{MTA10}}{Ever tried any form of smokeless tobacco products}
#'    \item{\code{MTA11}}{Used any smokeless tobacco products during the last month}
#'    \item{\code{MTA12A}}{Type of smokeless tobacco product used: Chewing tobacco}
#'    \item{\code{MTA12B}}{Type of smokeless tobacco product used: Snuff}
#'    \item{\code{MTA12D}}{Type of smokeless tobacco product used: PAN WITH TOBACCO}
#'    \item{\code{MTA12E}}{Type of smokeless tobacco product used: GUTKA}
#'    \item{\code{MTA12F}}{Type of smokeless tobacco product used: NASWAR}
#'    \item{\code{MTA12G}}{Type of smokeless tobacco product used: MAWA TOBACCO}
#'    \item{\code{MTA12H}}{Type of smokeless tobacco product used: PAN WITH TOBACCO}
#'    \item{\code{MTA12X}}{Type of smokeless tobacco product used: Other}
#'    \item{\code{MTA12NR}}{Type of smokeless tobacco product used: No response}
#'    \item{\code{MTA13}}{Number of days when smokeless tobacco products where used in past month}
#'    \item{\code{MLS1}}{Estimation of overall happiness}
#'    \item{\code{MLS2}}{Satisfaction with ladder step}
#'    \item{\code{MLS3}}{Life satisfaction in comparison with last year}
#'    \item{\code{MLS4}}{Life satisfaction expectation one year from now}
#'    \item{\code{HH4}}{Supervisor number}
#'    \item{\code{HH6}}{Area}
#'    \item{\code{MWDOB}}{Date of birth of man (CMC)}
#'    \item{\code{MWDOM}}{Date of marriage of man (CMC)}
#'    \item{\code{MWAGEM}}{Age at first marriage of man}
#'    \item{\code{MMSTATUS}}{Marital status of man}
#'    \item{\code{disability}}{Functional difficulties (age 18-49 years)}
#'    \item{\code{wscore}}{Combined wealth score}
#'    \item{\code{windex5}}{Wealth index quintile}
#'    \item{\code{windex10}}{Percentile Group of com1}
#'    \item{\code{wscoreu}}{Urban wealth score}
#'    \item{\code{windex5u}}{Urban wealth index quintile}
#'    \item{\code{windex10u}}{Percentile Group of urb1}
#'    \item{\code{wscorer}}{Rural wealth score}
#'    \item{\code{windex5r}}{Rural wealth index quintile}
#'    \item{\code{windex10r}}{Percentile Group of rur1}
#'    \item{\code{division}}{Division}
#'    \item{\code{majorcity}}{majorcity}
#'    \item{\code{hh6r}}{Area}
#'    \item{\code{suburban}}{ }
#'    \item{\code{hh7}}{Districts}
#'    \item{\code{mwelevel}}{Education}
#'    \item{\code{minsurance}}{Health insurance}
#'    \item{\code{mdisability}}{Functional difficulties (age 18-49 years)}
#'    \item{\code{mnweight}}{Men's sample weight}
#'    \item{\code{stratum}}{stratum}
#'    \item{\code{psu}}{psu}
#'   }
#'
#' @author
#'  \enumerate{
#'   \item{Muhammad Yaseen } {(\email{myaseen208@@gmail.com})}
#'   }
#'
#' @references
#' \enumerate{
#'   \item UNICEF MICS (\url{http://www.mics.unicef.org/surveys}).
#'  }
#'
#' @import tibble
#'
#' @examples
#' # Loading PakPMICS2018mn
#'  \dontrun{
#'  load(url(
#'   "https://github.com/myaseen208/PakPMICS2018Data/raw/master/PakPMICS2018mn.RData"
#'   ))
#'  }
NULL
