% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_downloadData.R
\name{wrcc_downloadData}
\alias{wrcc_downloadData}
\title{Download WRCC data}
\usage{
wrcc_downloadData(startdate = strftime(lubridate::now(), "\%Y010101", tz
  = "UTC"), enddate = strftime(lubridate::now(), "\%Y\%m\%d23", tz =
  "UTC"), unitID = NULL,
  baseUrl = "https://wrcc.dri.edu/cgi-bin/wea_list2.pl")
}
\arguments{
\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{enddate}{desired end date (integer or character representing YYYYMMDD[HH])}

\item{unitID}{station identifier (will be upcased)}

\item{baseUrl}{base URL for data queries}
}
\value{
String containing WRCC output.
}
\description{
Request data from a particular station for the desired time period.
Data are returned as a single character string containing the WRCC output.

Monitor unitIDs can be found at http://www.wrcc.dri.edu/cgi-bin/smoke.pl.
}
\examples{
\dontrun{
fileString <- wrcc_downloadData(20150701, 20150930, unitID = 'SM16')
df <- wrcc_parseData(fileString)
}
}
\references{
\href{http://www.wrcc.dri.edu/cgi-bin/smoke.pl}{Fire Cache Smoke Monitoring Archive}
}
\keyword{WRCC}
