% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addShadedBackground.R
\name{addShadedBackground}
\alias{addShadedBackground}
\title{Add Shaded Background to a Plot}
\usage{
addShadedBackground(
  param,
  timeAxis,
  breaks = stats::quantile(param, na.rm = TRUE),
  col = "blue",
  maxOpacity = 0.2,
  lwd = 1
)
}
\arguments{
\item{param}{vector of data to be represented}

\item{timeAxis}{vector of times of the same length as param}

\item{breaks}{set of breaks used to assign colors}

\item{col}{color for vertical lines}

\item{maxOpacity}{maximum opacity}

\item{lwd}{line width}
}
\description{
Adds vertical lines to an existing plot using any variable that shares the same
length as the time axis of the current plot. Line widths corresponds to magnitude of values.
}
