% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGoogleAddress.R
\name{addGoogleAddress}
\alias{addGoogleAddress}
\title{Add address information to a dataframe}
\usage{
addGoogleAddress(
  df,
  lonVar = "longitude",
  latVar = "latitude",
  existingMeta = NULL
)
}
\arguments{
\item{df}{dataframe with geolocation information (\emph{e.g.} those created by \code{wrcc_qualityControl()} or \code{airsis_qualityControl})}

\item{lonVar}{name of longitude variable in the incoming dataframe}

\item{latVar}{name of the latitude variable in the incoming dataframe}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}
}
\value{
Input dataframe with additional columns: \code{siteName, countyName}.
}
\description{
Google APIs are used to determine
address information associated with the locations specified by the
\code{longitude} and \code{latitude} columns of the incoming dataframe.

Address information is obtained by using the \pkg{ggmap} package.
}
\references{
\url{https://developers.google.com/maps/documentation/geocoding/overview}
}
\keyword{internal}
