% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_loadDaily.R
\name{monitor_loadDaily}
\alias{monitor_loadDaily}
\title{Load recent PM2.5 monitoring data}
\usage{
monitor_loadDaily(parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring/latest/RData",
  dataDir = NULL)
}
\arguments{
\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for 'daily' AirNow data files.}

\item{dataDir}{Local directory containing 'daily' data files.}
}
\value{
A \emph{ws_monitor} object with PM2.5 monitoring data.
}
\description{
Wrapper function to load and combine recent
data from AirNow, AIRSIS and WRCC:

\preformatted{
airnow <- airnow_loadDaily()
airsis <- airsis_loadDaily()
wrcc <- wrcc_loadDaily()
ws_monitor <- monitor_combine(list(airnow, airsis, wrcc))
}

If \code{dataDir} is defined, data will be loaded from this local
dirctory. Otherwise, data will be loaded from the monitoring data repository
maintained by PWFSL.

The daily files loaded by this function are updated once a day, shortly
after midnight and contain data for the previous 45 days.

For the most recent data, use \code{monitor_loadLatest()}.

For data extended more than 45 days into the past, use \code{monitor_load()}.

Currently supported parameters include the following:
\enumerate{
\item{PM2.5}
}

Avaialble RData files can be seen at:
\href{https://haze.airfire.org/monitoring/latest/RData/}{https://haze.airfire.org/monitoring/latest/RData/}
}
\examples{
\dontrun{
monitor_loadDaily() \%>\%
  monitor_subset(stateCodes=CONUS) \%>\%
  monitor_map()
}
}
\seealso{
\code{\link{monitor_load}}

\code{\link{monitor_loadLatest}}

\code{\link{monitor_loadAnnual}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
