% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_writeCurrentGeoJSON.R
\name{monitor_writeCurrentGeoJSON}
\alias{monitor_writeCurrentGeoJSON}
\title{Write Current Monitor Data to GeoJSON}
\usage{
monitor_writeCurrentGeoJSON(ws_monitor, filename,
  datetime = lubridate::now("UTC"), properties = NULL,
  propertyNames = NULL, metadataList = list())
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{filename}{filename where geojson file will be saved}

\item{datetime}{Time to which data will be 'current' (integer or character representing YYYYMMDDHH or \code{POSIXct}. 
If not \code{POSIXct}, interpreted as UTC time). 
So if \code{datetime} is 3 hours ago, a dataframe with the most current data from 3 hours ago will be returned.}

\item{properties}{optional character vector of properties to include for each monitor in geoJSON. 
If NULL all are included. May include any ws_monitor metadata and additional columns generated in \code{\link{monitor_currentData}}}

\item{propertyNames}{optional character vector supplying custom names for properties in geoJSON. If NULL or different length 
than \code{properties} defaults will be used.}

\item{metadataList}{list of top-level foreign members to include. May include nested lists as long as they can be converted into 
JSON using \code{jsonlite::toJSON()}. For more information on what can be included see 
\href{https://tools.ietf.org/html/rfc7946#section-6.1}{https://tools.ietf.org/html/rfc7946#section-6.1}}
}
\value{
invisibly returns geoJSON string.
}
\description{
Writes a geoJSON file containing current monitor data. For details on what is included, see 
\code{\link{monitor_currentData}}
}
\examples{
\dontrun{
wa <- loadLatest() \%>\% monitor_subset(stateCodes = 'WA')
wa_current_geojson <- monitor_writeCurrentGeoJSON(wa, 'wa_monitors.geojson')
wa_current_list <- jsonlite::fromJSON(wa_current)
wa_spdf <- rgdal::readOGR(dsn='wa_monitors.geojson', layer="OGRGeoJSON")
plot(wa_spdf)
map('state', 'washington', add = TRUE)
}
}
\keyword{ws_monitor}
