% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fowlerguggenheimLM.R
\name{fowlerguggenheim.LM}
\alias{fowlerguggenheim.LM}
\title{Fowler-Guggenheim Isotherm Linear Analysis}
\usage{
fowlerguggenheim.LM(Ce, theta, Temp)
}
\arguments{
\item{Ce}{is equal to the numerical value for the equilibrium capacity}

\item{theta}{is the fractional surface coverage}

\item{Temp}{temperature}
}
\value{
the linear regression, parameters for Fowler-Guggenheim isotherm,
and model error analysis
}
\description{
In Fowler-Guggenheim isotherm model, the lateral interaction of
the adsorbed molecules is taken into consideration. This is formulated on the
basis that the heat adsorption process may vary positively or negatively with
loading.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607,
0.80435, 1.10327, 1.58223)
theta  <- c(0.1972984, 0.3487013, 0.6147560, 0.7432401, 0.8854408,
0.8900708, 0.9106746, 0.9106746, 0.9611422)
Temp <- 298
fowlerguggenheim.LM(Ce, theta, Temp)
}
\references{
Fowler, R. H. and Guggenheim, E. A. (1939) Statistical Thermodynamics,
Cambridge University Press, London, England.

Foo, K. Y., and Hameed, B. H. (2009, September 13).
<doi:10.1016/j.cej.2009.09.013> Insights into the modeling of adsorption isotherm
systems. Chemical Engineering Journal.
}
\author{
Jemimah Christine L. Mesias

Chester C. Deocaris
}
