% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.trans.psa.R
\name{cv.trans.psa}
\alias{cv.trans.psa}
\title{Transformation of Factors to Individual Levels}
\usage{
cv.trans.psa(covariates, fcol = NULL)
}
\arguments{
\item{covariates}{A dataframe of covariates, presumably some factors.}

\item{fcol}{An optional vector containing the factor columns in the
covariate dataframe.  In NULL (default) routine to identfy factors
internally.}
}
\value{
Returns a dataframe \code{covariates.transformed} containing new
columns for each level of more than binary factors.  The rest of the
covariate dataframe stays unchanged.
}
\description{
The function \code{cv.trans.psa} takes a covariate data frame and replaces
each categorical covariate of n >=3 levels with \code{n} new binary
covariate columns, one for each level.  Transforms covariate dataframe for
use with the function \code{cv.bal.psa}.
}
\examples{

#Note reordering of columns, binary factor and numeric column are unchanged.
f2 <- factor(sample(c(0, 1), 20, replace = TRUE))
f4 <- factor(sample(c("a", "b", "c", "d"), 20, replace = TRUE))
cv <- rnorm(20)
X <- data.frame(f2, f4, cv)
cv.trans.psa(X)
#
f2 <- factor(sample(c('c', 'C'), 20, replace = TRUE))
f4 <- factor(sample(c("b", "A", "d", "CC"), 20, replace = TRUE))
cv <- rnorm(20)
X <- data.frame(f2, f4, cv)
cv.trans.psa(X)

}
\seealso{
\code{\link{cv.bal.psa}}, \code{\link{loess.psa}},
\code{\link{cstrata.psa}}, \code{\link{cv.trans.psa}}
}
\author{
James E. Helmreich \email{James.Helmreich@Marist.edu}

Robert M. Pruzek \email{RMPruzek@yahoo.com}

KuangNan Xiong \email{harryxkn@yahoo.com}
}
