% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bal.ks.psa.R
\name{bal.ks.psa}
\alias{bal.ks.psa}
\title{Kolgomorov-Smirnov 2 sample tests for multiple strata}
\usage{
bal.ks.psa(continuous, treatment = NULL, strata = NULL)
}
\arguments{
\item{continuous}{Quantitative covariate that is being balanced within
strata in a PSA. If \code{continuous} has three columns, then the second and
third are assumed to be the treatment and strata respectively.  Missing
values are not allowed.}

\item{treatment}{Binary variable of same length as \code{continuous};
generally 0 for 'control,' 1 for 'treatment.'}

\item{strata}{Integer variable (usually 1 - 5); A vector of same length as
continuous indicating the derived strata from estimated propensity scores.
Generally 5 or 6 strata are used, but graph works reasonably well at least
up to 10 strata.}
}
\value{
Returns a vector of same length as the number of strata containing
the p-values from the KS-test of equivalence of distributions for each
stratum-treatment pair.
}
\description{
Automates the Kolgomorov-Smirnov 2-sample nonparametric test of equivalence
of two distrbutions across multiple pairs of sample distributions.
}
\details{
Makes multiple calls to \code{ks.test}, returning a vector of p-values
associated with strata from a Propensity Score Analysis.
}
\examples{

continuous<-rnorm(1000)
treatment<-sample(c(0,1),1000,replace=TRUE)
strata<-sample(5,1000,replace=TRUE)
bal.ks.psa(continuous,treatment,strata)

}
\seealso{
\code{bal.ms.psa}, \code{bal.cs.psa}, \code{bal.cws.psa}
}
\author{
James E. Helmreich \email{James.Helmreich@Marist.edu}

Robert M. Pruzek \email{RMPruzek@yahoo.com}
}
\keyword{htest}
