% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wk-trans.R
\name{proj_trans_create}
\alias{proj_trans_create}
\title{Create a transformation object}
\usage{
proj_trans_create(source_crs, target_crs, use_z = NA, use_m = NA)
}
\arguments{
\item{source_crs, target_crs}{Source/Target CRS definition, coerced with \code{\link[wk:wk_crs_proj_definition]{wk::wk_crs_proj_definition()}}}

\item{use_z, use_m}{Used to declare the output type. Use \code{TRUE} to
ensure the output has that dimension, \code{FALSE} to ensure it does not,
and \code{NA} to leave the dimension unchanged.}
}
\value{
A PROJ transformation object
}
\description{
Creates a transformation object that transforms coordinates in a wk
pipeline.
}
\examples{
(trans <- proj_trans_create("EPSG:4326", "EPSG:3857"))
wk::wk_transform(wk::xy(1:5, 1:5), trans)

library(wk)
(invtrans <- wk_trans_inverse(trans))

h <- 1852 * 60
## the stretch of Mercator to a square
wk::wk_transform(wk::xy(c(-h * 180, 0, h * 180), c(-h * 180,0, h * 180)), invtrans)

}
