% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExp-add.R
\name{PPopt}
\alias{PPopt}
\title{Projection pursuit optimization}
\usage{
PPopt(origclass,origdata,q=1,PPmethod="LDA",weight=TRUE,r=1,
             lambda=0.1,energy=0,cooling=0.999,TOL=0.0001,maxiter = 50000)
}
\arguments{
\item{origclass}{class information vector}

\item{origdata}{data matrix without class information}

\item{q}{dimension of projection matrix}

\item{PPmethod}{method for projection pursuit; "LDA", "PDA", "Lr", "GINI", 
and "ENTROPY"}

\item{weight}{weight flag in LDA, PDA and Lr index}

\item{r}{r in Lr index}

\item{lambda}{lambda in PDA index}

\item{energy}{energy parameter}

\item{cooling}{cooling parameter}

\item{TOL}{tolerance}

\item{maxiter}{number of maximum iteration}
}
\value{
indexbest maximum LDA index value

projbest optimal q-dim projection matrix

origclass original class information vector

origdata  original data matrix  without class information
}
\description{
PP optimization using various projection pursuit indices
}
\details{
Find the q-dim optimal projection using various projectin pursuit indices 
with class information
}
\examples{
data(iris)
PP.proj.result <- PPopt(iris[,5],as.matrix(iris[,1:4]))
PP.proj.result
}
\references{
Lee, EK., Cook, D., Klinke, S., and Lumley, T.(2005) 
Projection Pursuit for exploratory supervised classification, 
Journal of Computational and Graphical statistics, 14(4):831-846.
}
\keyword{projection}
\keyword{pursuit}

