% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_p.R
\name{get_p}
\alias{get_p}
\alias{get_p.aov}
\alias{get_p.aovlist}
\title{Extract p-value from tests}
\usage{
get_p(x)

\method{get_p}{aov}(x)

\method{get_p}{aovlist}(x)
}
\arguments{
\item{x}{Test results.}
}
\value{
Returns either a single p value or, in case of multiple p values, a
 list or nested list with each p value.
}
\description{
This function attempts to extract p values from certain tests
 where it could otherwise be complicated to do so. Please make sure, in case
 of each new test, whether the function actually returns the values you want.
}
\details{
Supported functions: all tests that return the p value as \code{p.value}
(including most R \code{stats} test functions, having \code{htest} class),
and the \code{aov()} function (\code{aov} and \code{aovlist} classes).
}
\section{Methods (by class)}{
\itemize{
\item \code{get_p(aov)}: get_p method for class 'aov'

\item \code{get_p(aovlist)}: get_p method for class 'aovlist'

}}
\examples{

get_p(t.test(extra ~ group, data = sleep))
# returns 0.07939414
# same as printed via t.test(extra ~ group, data = sleep)

get_p(prop.test(c(83, 90, 129, 70), c(86, 93, 136, 82)))
# returns 0.005585477,
# same as printed prop.test(c(83, 90, 129, 70), c(86, 93, 136, 82))

get_p(aov(yield ~ block + N * P * K, npk))
# returns list of p values
# corresponds to summary(aov(yield ~ block + N * P * K, npk))

get_p(aov(yield ~ N * P * K + Error(block), npk))
# returns nested list of p values (effects per error term)
# again corresponds printed p values via summary()

}
