% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mandelh.R
\name{Mandel-h}
\alias{Mandel-h}
\alias{qmandelh}
\alias{pmandelh}
\title{Mandel's h Distribution}
\usage{
qmandelh(p, k, lower.tail = TRUE, log.p = FALSE)

pmandelh(q, k, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{vector of probabilities.}

\item{k}{number of groups.}

\item{lower.tail}{logical; if TRUE (default),
probabilities are \eqn{P[X \leq x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if \code{TRUE}, probabilities
are given as log(p).}

\item{q}{vector of quantiles.}
}
\value{
\code{pmandelh} gives the distribution function and
\code{qmandelh} gives the quantile function.
}
\description{
Distribution function and quantile function
for Mandel's h distribution.
}
\section{Source}{

The code for \code{pmandelh} was taken from:\cr
Stephen L R Ellison. (2017). metRology: Support for Metrological
Applications. R package version 0.9-26-2.
\url{https://CRAN.R-project.org/package=metRology}
}

\examples{
## We need a two-sided upper-tail quantile
qmandelh(p = 0.005/2, k = 7, lower.tail=FALSE)
}
\references{
Practice E 691 (2005) \emph{Standard Practice for
Conducting an Interlaboratory Study to Determine the
Precision of a Test Method}, ASTM International.
}
\seealso{
\code{\link{mandelhTest}}
}
\keyword{distribution}
