% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vanWaerdenAllPairsTest.R
\name{vanWaerdenAllPairsTest}
\alias{vanWaerdenAllPairsTest}
\alias{vanWaerdenAllPairsTest.default}
\alias{vanWaerdenAllPairsTest.formula}
\title{van-der-Waerden's All-Pairs Comparison Normal Scores Test}
\usage{
vanWaerdenAllPairsTest(x, ...)

\method{vanWaerdenAllPairsTest}{default}(
  x,
  g,
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)

\method{vanWaerdenAllPairsTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{p.adjust.method}{method for adjusting p values (see \code{\link{p.adjust}}).}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs van-der-Waerden all-pairs comparison
normal scores test.
}
\details{
For all-pairs comparisons in an one-factorial layout
with non-normally distributed residuals van-der-Waerden's
normal scores transformation can be used prior to
an all-pairs comparison test. A total of \eqn{m = k(k-1)/2}
hypotheses can be tested. The null hypothesis
H\eqn{_{ij}: F_i(x) = F_j(x)} is tested in the two-tailed test
against the alternative
A\eqn{_{ij}: F_i(x) \ne F_j(x), ~~ i \ne j}.
For \code{p.adjust.method = "single-step"} the
Tukey's studentized range distribution is used to calculate
p-values (see \code{\link{Tukey}}). Otherwise, the
t-distribution is used for the calculation of p-values
with a latter p-value adjustment as
performed by \code{\link{p.adjust}}.
}
\references{
Conover, W. J., Iman, R. L. (1979) \emph{On multiple-comparisons procedures},
Tech. Rep. LA-7677-MS, Los Alamos Scientific Laboratory.

van der Waerden, B. L. (1952) Order tests for the two-sample
problem and their power, \emph{Indagationes Mathematicae} \bold{14}, 453--458.
}
\seealso{
\code{\link{vanWaerdenTest}}, \code{\link{vanWaerdenManyOneTest}},
\code{\link[SuppDists]{normOrder}}.
}
\concept{AllPairsComparison}
\concept{NormalScores}
\keyword{htest}
\keyword{nonparametric}
