% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frdManyOneDemsarTest.R
\name{frdManyOneDemsarTest}
\alias{frdManyOneDemsarTest}
\alias{frdManyOneDemsarTest.default}
\title{Demsar's Many-to-One Test
for Unreplicated Blocked Data}
\usage{
frdManyOneDemsarTest(y, ...)

\method{frdManyOneDemsarTest}{default}(y, groups, blocks,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = p.adjust.methods, ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}}).}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Demsar's non-parametric many-to-one comparison test
for Friedman-type ranked data.
}
\details{
For many-to-one comparisons (pairwise comparisons with one control)
in a two factorial unreplicated complete block design
with non-normally distributed residuals, Demsar's test can be
performed on Friedman-type ranked data.

Let there be \eqn{k} groups including the control,
then the number of treatment levels is \eqn{m = k - 1}.
A total of \eqn{m} pairwise comparisons can be performed between
the \eqn{i}-th treatment level and the control.
H\eqn{_i: \theta_0 = \theta_i} is tested in the two-tailed case against
A\eqn{_i: \theta_0 \ne \theta_i, ~~ (1 \le i \le m)}.

The \eqn{p}-values are computed from the standard normal distribution.
Any of the \eqn{p}-adjustment methods as included in \code{\link{p.adjust}}
can be used for the adjustment of \eqn{p}-values.
}
\examples{
 ## Sachs, 1997, p. 675
 ## Six persons (block) received six different diuretics
 ## (A to F, treatment).
 ## The responses are the Na-concentration (mval)
 ## in the urine measured 2 hours after each treatment.
 ## Assume A is the control.

 y <- matrix(c(
 3.88, 5.64, 5.76, 4.25, 5.91, 4.33, 30.58, 30.14, 16.92,
 23.19, 26.74, 10.91, 25.24, 33.52, 25.45, 18.85, 20.45, 
 26.67, 4.44, 7.94, 4.04, 4.4, 4.23, 4.36, 29.41, 30.72,
 32.92, 28.23, 23.35, 12, 38.87, 33.12, 39.15, 28.06, 38.23,
 26.65),nrow=6, ncol=6, 
 dimnames=list(1:6, LETTERS[1:6]))

 ## Global Friedman test
 friedmanTest(y)

 ## Demsar's many-one test
 frdManyOneDemsarTest(y=y, p.adjust = "bonferroni")

 ## Exact many-one test
 frdManyOneExactTest(y=y, p.adjust = "bonferroni")

 ## Nemenyi's many-one test
 frdManyOneNemenyiTest(y=y)
 
}
\references{
Demsar, J. (2006) Statistical comparisons of classifiers over multiple
 data sets, \emph{Journal of Machine Learning Research} \bold{7}, 1--30.
}
\seealso{
\code{\link{friedmanTest}}, \code{\link[stats]{friedman.test}},
\code{\link{frdManyOneExactTest}}, \code{\link{frdManyOneNemenyiTest}}.
}
\concept{
FriedmanTest

Rank

ManyToOne
}
\keyword{htest}
\keyword{nonparametric}
