% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_utils.R
\name{prepare_data_from_phyloseq}
\alias{prepare_data_from_phyloseq}
\title{Prepare data for use in PLN models from a phyloseq object}
\usage{
prepare_data_from_phyloseq(physeq, offset = "TSS", ...)
}
\arguments{
\item{physeq}{Required. A phyloseq class object from which the count table and covariates data.frame are extracted.}

\item{offset}{Optional. Normalisation scheme used to compute scaling factors used as offset during PLN inference. Available schemes are "TSS" (Total Sum Scaling, default), "CSS" (Cumulative Sum Scaling, used in metagenomeSeq), "RLE" (Relative Log Expression, used in DESeq2), "GMPR" (Geometric Mean of Pairwise Ratio, introduced in Chen et al., 2018) or "none". Alternatively the user can supply its own vector or matrix of offsets (see note for specification of the user-supplied offsets).}

\item{...}{Addtional arguments passed on to \code{\link[=compute_offset]{compute_offset}}}
}
\description{
Wrapper around \code{\link[=prepare_data]{prepare_data}}, extracts the count table and the covariates data.frame from a "phyloseq" class object
before passing them to \code{\link[=prepare_data]{prepare_data}}. See \code{\link[=prepare_data]{prepare_data}} for details.
}
\details{
This functions depends on the phyloseq package which is not a proper dependency of PLNmodels as it is not available on CRAN
}
\examples{
## Requires the phyloseq package
\dontrun{
library(phyloseq)
data(enterotypes)
prepare_data_from_phyloseq(enterotypes)
}
}
\seealso{
\code{\link[=compute_offset]{compute_offset}} and \code{\link[=prepare_data]{prepare_data}}
}
