% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-class.R
\name{PLNfit}
\alias{PLNfit}
\title{An R6 Class to represent a PLNfit in a standard, general framework}
\description{
The function \code{\link[=PLN]{PLN()}} fit a model which is an instance of a object with class \code{\link{PLNfit}}.
Objects produced by the functions \code{\link[=PLNnetwork]{PLNnetwork()}}, \code{\link[=PLNPCA]{PLNPCA()}}, \code{\link[=PLNmixture]{PLNmixture()}} and \code{\link[=PLNLDA]{PLNLDA()}} also enjoy the methods of \code{\link[=PLNfit]{PLNfit()}} by inheritance.

This class comes with a set of R6 methods, some of them being useful for the user and exported as S3 methods.
See the documentation for \code{\link[=coef]{coef()}}, \code{\link[=sigma]{sigma()}},
\code{\link[=predict]{predict()}}, \code{\link[=vcov]{vcov()}} and \code{\link[=standard_error]{standard_error()}}.

Fields are accessed via active binding and cannot be changed by the user.
}
\details{
The parameter \code{control} is a list controlling the optimization with the following entries:
\itemize{
\item "covariance" character setting the model for the covariance matrix. Either "full", "diagonal", "spherical" or "genetic". Default is "full".
\item "corr_matrix": a symmetric positive definite correlation matrix used for the "genetic" model of covariance. Useless in other cases
\item "trace" integer for verbosity.
\item "inception" Set up the initialization. By default, the model is initialized with a multivariate linear model applied on
log-transformed data, and with the same formula as the one provided by the user. However, the user can provide a PLNfit (typically obtained from a previous fit),
which sometimes speeds up the inference.
\item "ftol_rel" stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 1e-6 when n < p, 1e-8 otherwise.
\item "ftol_abs" stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 0
\item "xtol_rel" stop when an optimization step changes every parameters by less than xtol multiplied by the absolute value of the parameter. Default is 1e-4
\item "xtol_abs" stop when an optimization step changes every parameters by less than xtol multiplied by the absolute value of the parameter. Default is 0
\item "maxeval" stop when the number of iteration exceeds maxeval. Default is 10000
\item "maxtime" stop when the optimization time (in seconds) exceeds maxtime. Default is -1 (no restriction)
\item "algorithm" the optimization method used by NLOPT among LD type, i.e. "CCSAQ", "MMA", "LBFGS", "VAR1", "VAR2". See NLOPT documentation for further details. Default is "CCSAQ".
}
}
\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1, data = trichoptera)
class(myPLN)
print(myPLN)
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{n}}{number of samples}

\item{\code{q}}{number of dimensions of the latent space}

\item{\code{p}}{number of species}

\item{\code{d}}{number of covariates}

\item{\code{model_par}}{a list with the matrices of parameters found in the model (Theta, Sigma, plus some others depending on the variant)}

\item{\code{fisher}}{Variational approximation of the Fisher Information matrix}

\item{\code{std_err}}{Variational approximation of the variance-covariance matrix of model parameters estimates.}

\item{\code{var_par}}{a list with two matrices, M and S2, which are the estimated parameters in the variational approximation}

\item{\code{gen_par}}{a list with two parameters, sigma2 and rho, only used with the genetic covariance model}

\item{\code{latent}}{a matrix: values of the latent vector (Z in the model)}

\item{\code{latent_pos}}{a matrix: values of the latent position vector (Z) without covariates effects or offset}

\item{\code{fitted}}{a matrix: fitted values of the observations (A in the model)}

\item{\code{nb_param}}{number of parameters in the current PLN model}

\item{\code{vcov_model}}{character: the model used for the covariance (either "spherical", "diagonal" or "full")}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{weights}}{observational weights}

\item{\code{loglik}}{(weighted) variational lower bound of the loglikelihood}

\item{\code{loglik_vec}}{element-wise variational lower bound of the loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{entropy}}{Entropy of the variational distribution}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{R_squared}}{approximated goodness-of-fit criterion}

\item{\code{criteria}}{a vector with loglik, BIC, ICL and number of parameters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PLNfit-update}{\code{PLNfit$update()}}
\item \href{#method-PLNfit-new}{\code{PLNfit$new()}}
\item \href{#method-PLNfit-optimize}{\code{PLNfit$optimize()}}
\item \href{#method-PLNfit-VEstep}{\code{PLNfit$VEstep()}}
\item \href{#method-PLNfit-set_R2}{\code{PLNfit$set_R2()}}
\item \href{#method-PLNfit-compute_fisher}{\code{PLNfit$compute_fisher()}}
\item \href{#method-PLNfit-compute_standard_error}{\code{PLNfit$compute_standard_error()}}
\item \href{#method-PLNfit-postTreatment}{\code{PLNfit$postTreatment()}}
\item \href{#method-PLNfit-predict}{\code{PLNfit$predict()}}
\item \href{#method-PLNfit-predict_cond}{\code{PLNfit$predict_cond()}}
\item \href{#method-PLNfit-show}{\code{PLNfit$show()}}
\item \href{#method-PLNfit-print}{\code{PLNfit$print()}}
\item \href{#method-PLNfit-clone}{\code{PLNfit$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-update"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-update}{}}}
\subsection{Method \code{update()}}{
Update a \code{\link{PLNfit}} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$update(
  Theta = NA,
  Sigma = NA,
  M = NA,
  S2 = NA,
  Ji = NA,
  R2 = NA,
  Z = NA,
  A = NA,
  monitoring = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Theta}}{matrix of regression matrix}

\item{\code{Sigma}}{variance-covariance matrix of the latent variables}

\item{\code{M}}{matrix of mean vectors for the variational approximation}

\item{\code{S2}}{matrix of variance vectors for the variational approximation}

\item{\code{Ji}}{vector of variational lower bounds of the log-likelihoods (one value per sample)}

\item{\code{R2}}{approximate R^2 goodness-of-fit criterion}

\item{\code{Z}}{matrix of latent vectors (includes covariates and offset effects)}

\item{\code{A}}{matrix of fitted values}

\item{\code{monitoring}}{a list with optimization monitoring quantities}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Update the current \code{\link{PLNfit}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-new"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{\link{PLNfit}} model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$new(responses, covariates, offsets, weights, formula, xlevels, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{formula}}{model formula used for fitting, extracted from the formula in the upper-level call}

\item{\code{xlevels}}{named listed of factor levels included in the models, extracted from the formula in the upper-level call and used for predictions.}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-optimize}{}}}
\subsection{Method \code{optimize()}}{
Call to the C++ optimizer and update of the relevant fields
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$optimize(responses, covariates, offsets, weights, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-VEstep"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-VEstep}{}}}
\subsection{Method \code{VEstep()}}{
Result of one call to the VE step of the optimization procedure: optimal variational parameters (M, S) and corresponding log likelihood values for fixed model parameters (Sigma, Theta). Intended to position new data in the latent space.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$VEstep(
  covariates,
  offsets,
  responses,
  weights,
  Theta = self$model_par$Theta,
  Sigma = self$model_par$Sigma,
  control = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{Theta}}{Optional fixed value of the regression parameters}

\item{\code{Sigma}}{Optional fixed value of the covariance parameters.}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with three components:
\itemize{
\item the matrix \code{M} of variational means,
\item the matrix \code{S2} of variational variances
\item the vector \code{log.lik} of (variational) log-likelihood of each new observation
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-set_R2"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-set_R2}{}}}
\subsection{Method \code{set_R2()}}{
Update R2 field after optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$set_R2(responses, covariates, offsets, weights, nullModel = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{nullModel}}{null model used for approximate R2 computations. Defaults to a GLM model with same design matrix but not latent variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-compute_fisher"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-compute_fisher}{}}}
\subsection{Method \code{compute_fisher()}}{
Safely compute the fisher information matrix (FIM)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$compute_fisher(type = c("wald", "louis"), X = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{approximation scheme to compute the fisher information matrix. Either \code{wald} (default) or \code{louis}. \code{type = "louis"} results in smaller confidence intervals.}

\item{\code{X}}{design matrix used to compute the FIM}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a sparse matrix with sensible dimension names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-compute_standard_error"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-compute_standard_error}{}}}
\subsection{Method \code{compute_standard_error()}}{
Compute univariate standard error for coefficients of Theta from the FIM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$compute_standard_error()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a matrix of standard deviations.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-postTreatment"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-postTreatment}{}}}
\subsection{Method \code{postTreatment()}}{
Update R2, fisher and std_err fields after optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$postTreatment(
  responses,
  covariates,
  offsets,
  weights = rep(1, nrow(responses)),
  type = c("wald", "louis", "none"),
  nullModel = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses (called Y in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{covariates}}{design matrix (called X in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{offsets}}{offset matrix (called O in the model). Will usually be extracted from the corresponding field in PLNfamily-class}

\item{\code{weights}}{an optional vector of observation weights to be used in the fitting process.}

\item{\code{type}}{approximation scheme to compute the fisher information matrix. Either \code{wald} (default) or \code{louis}. \code{type = "louis"} results in smaller confidence intervals.}

\item{\code{nullModel}}{null model used for approximate R2 computations. Defaults to a GLM model with same design matrix but not latent variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-predict"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-predict}{}}}
\subsection{Method \code{predict()}}{
Predict position, scores or observations of new data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$predict(newdata, type = c("link", "response"), envir = parent.frame())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{A data frame in which to look for variables with which to predict. If omitted, the fitted values are used.}

\item{\code{type}}{Scale used for the prediction. Either \code{link} (default, predicted positions in the latent space) or \code{response} (predicted counts).}

\item{\code{envir}}{Environment in which the prediction is evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix with predictions scores or counts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-predict_cond"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-predict_cond}{}}}
\subsection{Method \code{predict_cond()}}{
Predict position, scores or observations of new data, conditionally on the observation of a (set of) variables
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$predict_cond(
  newdata,
  cond_responses,
  type = c("link", "response"),
  var_par = FALSE,
  envir = parent.frame()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{a data frame containing the covariates of the sites where to predict}

\item{\code{cond_responses}}{a data frame containing the count of the observed variables (matching the names of the provided as data in the PLN function)}

\item{\code{type}}{Scale used for the prediction. Either \code{link} (default, predicted positions in the latent space) or \code{response} (predicted counts).}

\item{\code{var_par}}{Boolean. Should new estimations of the variational parameters of mean and variance be sent back, as attributes of the matrix of predictions. Default to \code{FALSE}.}

\item{\code{envir}}{Environment in which the prediction is evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix with predictions scores or counts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-show"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-show}{}}}
\subsection{Method \code{show()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$show(
  model = paste("A multivariate Poisson Lognormal fit with", private$covariance,
    "covariance model.\\n")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{First line of the print output}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-print"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-print}{}}}
\subsection{Method \code{print()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
