# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Log-Likelihood of Matrix-Variate Normal Data
#' @description \loadmathjax
#' Log-likelihood of i.i.d data from 
#' \mjseqn{N_{r \ times c}(0, \Psi, \Sigma)}, i.e.
#' \mjsdeqn{ logLik = (-0.5) 
#'     \Big( nrc \log(2\pi) + nc \log |\Psi| + nr \log |\Sigma| + 
#'         \sum_{i=1}^n \| \Psi^{-1/2} (X_i - M) \Sigma^{-1/2} \|_F^2 \Big) .}
#'
#' @param x Array.
#' @param PsiInv Row precision matrix, i.e., \mjseqn{\Psi^{-1}}.
#' @param SigInv Column precision matrix, i.e., \mjseqn{\Sigma^{-1}}.
#'
#' @return Log-likelihood value.
#'
#' @noRd
NULL

#' @title MLE of \mjseqn{\Psi} and \mjseqn{\Sigma}
#' @description \loadmathjax
#' It supposes the data are sampled independently from
#'   \mjseqn{N(0, \Psi, \Sigma)}.
#'
#' @param x Array.
#' @param maxIter Maximal step of iterations.
#' @param tol Tolerance.
#'
#' @return `list(Psi, PsiInv, Sig, SigInv, logLik)`.
#'
#' @noRd
NULL

#' @title Center Data
#'
#' @param x1 See [get_suppSet()].
#' @param x2 See [get_suppSet()].
#' @param flag The result returned from [get_suppSet()].
#'
#' @return Array.
#'
#' @noRd
NULL

#' @title Mean Matrices
#' @description
#' If `isTRUE(flag(i, j))`, `M1(i, j)` and `M2(i, j)` are estimated as
#' the pooled mean value.
#'
#' @param x1 See [get_suppSet()].
#' @param x2 See [get_suppSet()].
#' @param flag Logical matrix returned from [get_suppSet()].
#'
#' @return `list(M1, M2)`.
#'
#' @noRd
cxx_mean <- function(x1, x2, flag) {
    .Call(`_PLFD_cxx_mean`, x1, x2, flag)
}

#' @title MLE of Row and Column Precision Matrices
#'
#' @param x1  See [get_suppSet()].
#' @param x2  See [get_suppSet()].
#' @param flag Matrix returned from [get_suppSet()].
#'
#' @return See the value of [cxx_mle()].
#'
#' @noRd
cxx_prec <- function(x1, x2, flag) {
    .Call(`_PLFD_cxx_prec`, x1, x2, flag)
}

