% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_get_prototype.R
\name{pl_get_prototype}
\alias{pl_get_prototype}
\title{Download TIGER Prototype shapefiles}
\usage{
pl_get_prototype(
  geog,
  year = 2020,
  full_state = TRUE,
  cache_to = NULL,
  clean_names = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{geog}{Geography to download data for. See details for full list.}

\item{year}{year, either 2010 or 2020}

\item{full_state}{whether to return the full state (TRUE) or the single county subset (FALSE)}

\item{cache_to}{the file name, if any, to cache the results to (as an RDS).
If a file exists and \code{refresh=FALSE}, will read from this file.}

\item{clean_names}{whether to clean and rename columns}

\item{refresh}{if \code{TRUE}, force a re-download of the data.}
}
\value{
An \code{sf} object containing the blocks.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
These prototype shapefiles correspond to the Rhode Island end-to-end Census
test and the accompanying prototype P.L. 94-171 data. This function is
unlikely to be useful for working with any actual decennial Census data.
The corresponding \code{tigris} functions should be used instead.
}
\details{
Current acceptable arguments to geog include:
\itemize{
\item \code{block}: block
\item \code{block_group}: block group
\item \code{tract}: tract
\item \code{county}: county
\item \code{state}: state
\item \code{sld_low}: state legislative district lower house
\item \code{sld_up}: state legislative district upper house
\item \code{congressional_district}: federal congressional district
\item \code{place}: Census place
\item \code{voting_district}: voting tabulation district
}
}
\examples{
\donttest{
shp <- pl_get_prototype("block")
}

}
\concept{advanced}
