% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_bins.R
\name{set_bins}
\alias{set_bins}
\title{given a set of bin ranges, assign each value to a bin}
\usage{
set_bins(
  x,
  breaks = stats::quantile(x, na.rm = T),
  lower_bound = -Inf,
  upper_bound = Inf,
  quiet = TRUE,
  between = NULL,
  inclusive = TRUE
)
}
\arguments{
\item{x}{numeric vector to assign bins}

\item{breaks}{breaks for each bin, defaults to quantiles}

\item{lower_bound}{set a lower bound for the first bin, defaults to -Inf}

\item{upper_bound}{set an upper bound for the last bind, defaults to Inf}

\item{quiet}{whether to give additonal information regarding bins and assigned range for each}

\item{between}{defaults to NULL, a special case of setting all inside the specified range}

\item{inclusive}{include max value of largest user defined bin even though lower bins are non-inclusive}
}
\description{
given a set of bin ranges, assign each value to a bin
}
\details{
Given a set of quantiles/bins/etc established from a separate dataset, it can 
be useful to assign the same bins to new or simulated data for comparisons
or to do additional analysis such as assign dropouts etc. This function can be
used to take the breakpoints to establish bins quickly and easily

If there is concern over data being outside the range of the assigned breaks, 
one can assign -Inf to lower and/or Inf to upper to make sure all values will be 
assigned to a bin

To use the between functionality, you must specify the range you wish to bin between,
and those values will be assigned to bin 1, with all values below as 0 and all values
above as 2. See the examples for more details
}
