% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_attributes.R
\name{strip_attributes}
\alias{strip_attributes}
\title{strip additional attributes that make dplyr fail}
\usage{
strip_attributes(df, attr_names)
}
\arguments{
\item{df}{dataframe}

\item{attr_names}{names of attributes that you want to remove}
}
\description{
strip additional attributes that make dplyr fail
}
\details{
dplyr as of 0.4 still does not handle columns with non-generic attributes and
will error out rather than ignoring them etc.
This function will allow one to strip attribute names to allow the data frame to be
used within the dplyr pipeline without issue.

This type of data is common when dealing with SAS datasets
}
\examples{
\dontrun{
foo <- data.frame(a = 1:5, b = 1:5, c=letters[1:5])
df <- foo
attr(df$a, "label") <- "col a"
attr(df$b, "label") <- "col b"
attr(df$c, "label") <- "col c"

library(dplyr)
df \%>\% filter(a \%in\% c(1, 2)) # will throw an error
df \%>\% strip_attributes("label") \%>\% filter(a \%in\% c(1, 2))

attr(df$a, "notes") <- "a note"
# now column a has attributes of label and notes
df \%>\% strip_attributes(c("label", "notes")) \%>\% filter(a \%in\% c(1, 2))
}
}
