\name{read.phylog.matrix}
\alias{read.phylog.matrix}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Read a Phylogenetic Covariance Matrix}
\description{
  Reads a dsc matrix file ---returned from the PDDIST program--- and
  converts into an R matrix for subsequent use.}
\usage{
read.phylog.matrix(x)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{x}{An ASCII data file such as the *.dsc file generated by the
   PDDIST program}
}
\value{a phylogenetic variance-covariance matrix that can be used in R
  functions, such as for GLS models.} 
\references{
  Diaz-Uriarte, R., and Garland, T., Jr., in prep. PHYLOGR:
  an R package for the analysis of comparative data via Monte Carlo
  simulations and generalized least squares approaches.
  
  Garland, T. Jr. and Ives, A. R. (2000) Using the past to predict the
  present: confidence intervals for regression equations in phylogenetic
  comparative methods. \emph{The American Naturalist}, 155, 346-364.
}
\author{Ramon Diaz-Uriarte and Theodore Garland, Jr.}


\seealso{ \code{\link{matrix.D}},  \code{\link{phylog.gls.fit}}}


\examples{
%#ifdef unix
# First need to find where the example data sets are
 path.to.example <- paste(path.package(package="PHYLOGR"),"Examples/",sep="/") 
%#endif


%#ifdef windows
% path.to.example <-
%paste(path.package(package="phylog"),"Examples\\",sep="\\") # where the example data sets are
%#endif

example.dsc.file <- paste(path.to.example,"ifsmi.dsc",sep="") 
phylog.matrix1 <- read.phylog.matrix(example.dsc.file)


# You could jump directly to the call to the function if you
# are willing to enter the path explicitly.
# For example in some Linux systems the following works
# read.phylog.matrix("/usr/lib/R/library/PHYLOGR/Examples/hb12n.dsc")
# In Windows, maybe do:
# read.phylog.matrix("c:\\\\progra~1\\\\rw1001\\\\library\\\\PHYLOGR\\\\Examples\\\\hb12n.dsc")




}
\keyword{manip}%-- one or more ...
