% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Proportions.R
\name{phe_proportion}
\alias{phe_proportion}
\title{phe_proportion}
\usage{
phe_proportion(data, x, n, type = "standard", confidence = 0.95,
  percentage = FALSE)
}
\arguments{
\item{data}{a data.frame containing the data to calculate proportions for; unquoted string; no default}

\item{x}{field name from data containing the observed numbers of cases in the sample meeting the required condition
(the numerator for the proportion); unquoted string; no default}

\item{n}{field name from data containing the number of cases in the sample (the denominator for the proportion);
unquoted string; no default}

\item{type}{type of output; can be "value", "lower", "upper", "standard" (for all 3 previous fields) or "full"; quoted string; default standard}

\item{confidence}{the required level of confidence expressed as a number between 0.9 and 1
or 90 and 100; numeric; default 0.95}

\item{percentage}{whether the output should be returned as a percentage; logical; default FALSE}
}
\value{
When type = "full", returns the original data.frame with the following appended:
        proportion, lower confidence limit, upper confidence limit, confidence level, statistic and method
}
\description{
Calculates proportions with confidence limits using Wilson Score method [1,2].
}
\section{Notes}{
 Wilson Score method [1,2] is applied using the \code{\link{wilson_lower}}
 and \code{\link{wilson_upper}} functions.
}

\examples{
df <- data.frame(area = c("Area1","Area2","Area3"),
                 numerator = c(65,82,100),
                 denominator = c(100,100,100))

phe_proportion(df, numerator, denominator)
phe_proportion(df, numerator, denominator, confidence=99.8)
phe_proportion(df, numerator, denominator, type="full")

}
\references{
[1] Wilson EB. Probable inference, the law of succession, and statistical
 inference. J Am Stat Assoc; 1927; 22. Pg 209 to 212. \cr
[2] Newcombe RG, Altman DG. Proportions and their differences. In Altman
 DG et al. (eds). Statistics with confidence (2nd edn). London: BMJ Books;
 2000. Pg 46 to 48.
}
\seealso{
Other PHEindicatormethods package functions: \code{\link{byars_lower}},
  \code{\link{byars_upper}}, \code{\link{phe_dsr}},
  \code{\link{phe_isr}}, \code{\link{phe_mean}},
  \code{\link{phe_rate}}, \code{\link{phe_smr}},
  \code{\link{wilson_lower}}, \code{\link{wilson_upper}}
}
