% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEAXAI_targets.R
\name{PEAXAI_targets}
\alias{PEAXAI_targets}
\title{Projection-Based Efficiency Targets}
\usage{
PEAXAI_targets(
  data,
  x,
  y,
  final_model,
  efficiency_thresholds,
  directional_vector,
  n_expand,
  n_grid,
  max_y = 2,
  min_x = 1
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} containing input and output variables.}

\item{x}{A numeric vector indicating the column indexes of input variables in \code{data}.}

\item{y}{A numeric vector indicating the column indexes of output variables in \code{data}.}

\item{final_model}{A fitted \pkg{caret} model of class \code{"train"} that supports
\code{predict(type = "prob")} and returns a probability column for the efficient class.}

\item{efficiency_thresholds}{A numeric vector of probability levels in (0,1)
that define the efficiency classes (e.g., \code{c(0.75, 0.9, 0.95)}).}

\item{directional_vector}{A \code{list} with the required information to
construct the directional vector, including:
\itemize{
\item \code{relative_importance}: Numeric vector of variable importances that sum to 1.
\item \code{scope}: \code{"global"} (currently supported) or \code{"local"}.
\item \code{baseline}: \code{"mean"}, \code{"median"}, \code{"self"} or \code{"ones"}.
}}

\item{n_expand}{Numeric. Number of expansion steps used to enlarge the initial
search range for \eqn{\beta}.}

\item{n_grid}{Integer. Number of grid points evaluated during each iteration
to refine the cutoff value of \eqn{\beta}.}

\item{max_y}{Numeric. Upper-limit multiplier for output expansion in the search
procedure (default = 2).}

\item{min_x}{Numeric. Lower-limit multiplier for input contraction in the search
procedure (default = 1).}
}
\value{
A named \code{list} with one element per threshold. Each element contains:
\itemize{
\item \code{data}: A \code{data.frame} of projected input–output values at that threshold.
\item \code{beta}: A two-column \code{data.frame} with the optimal \eqn{\beta}
and the corresponding predicted probability.
}
}
\description{
Computes efficiency projections for each observation based on a trained
classifier from \pkg{caret} that provides class probabilities via
\code{predict(type = "prob")}. For each probability threshold, the function
finds the direction and magnitude of change in input–output space required
for a unit to reach a specified efficiency level, following a directional
distance approach.
}
\details{
For each observation and for each probability level in \code{efficiency_thresholds},
the function searches for the smallest directional distance \eqn{\beta} such that
the predicted probability of belonging to the efficient class reaches the target.
}
\examples{
\donttest{
  data("firms", package = "PEAXAI")

  data <- subset(
    firms,
    autonomous_community == "Comunidad Valenciana"
  )

  x <- 1:4
  y <- 5
  RTS <- "vrs"
  imbalance_rate <- NULL

  trControl <- list(
    method = "cv",
    number = 3
  )

  # glm method
  methods <- list(
    "glm" = list(
      weights = "dinamic"
     )
   )

  metric_priority <- c("Balanced_Accuracy", "ROC_AUC")

  models <- PEAXAI_fitting(
    data = data, x = x, y = y, RTS = RTS,
    imbalance_rate = imbalance_rate,
    methods = methods,
    trControl = trControl,
    metric_priority = metric_priority,
    verbose = FALSE,
    seed = 1
  )

  final_model <- models[["best_model_fit"]][["glm"]]

  relative_importance <- PEAXAI_global_importance(
    data = data, x = x, y = y,
    final_model = final_model,
    background = "real", target = "real",
    importance_method = list(name = "PI", n.repetitions = 5)
  )

  efficiency_thresholds <- seq(0.75, 0.95, 0.1)

  directional_vector <- list(relative_importance = relative_importance,
  scope = "global", baseline  = "mean")

  targets <- PEAXAI_targets(data = data, x = x, y = y, final_model = final_model,
  efficiency_thresholds = efficiency_thresholds, directional_vector = directional_vector,
  n_expand = 0.5, n_grid = 50, max_y = 2, min_x = 1)
}

}
\seealso{
\code{\link{find_beta_maxmin}} for initializing search bounds;
\code{\link[caret]{train}} for model training.
}
