% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMRS-package.R
\docType{package}
\name{PCMRS-package}
\alias{PCMRS-package}
\title{Model Response Styles in Partial Credit Models}
\description{
Performs PCMRS, a method to model response styles in Partial Credit Models
}
\examples{
\dontshow{
k <- 4; n <- 80; I <- 4
set.seed(1860)
Y <- as.data.frame(matrix(sample(1:k, I*n, TRUE),nrow = n))
Y <- data.frame(lapply(Y, as.ordered))

mini.ex <- PCMRS(Y, cores = 2)
mini.ex
}
\dontrun{
################################################
## Small example to illustrate model and person estimation
################################################

data(tenseness)

set.seed(5)
samples <- sample(1:nrow(tenseness), 100)
tense_small <- tenseness[samples,1:4]

m_small <- PCMRS(tense_small, cores = 2)
m_small
plot(m_small)

persons <- person.posterior(m_small, cores = 2)
plot(jitter(persons, 100))

################################################
## Example from Tutz et al. 2017:
################################################

data(emotion)
m.emotion <- PCMRS(emotion)
m.emotion

plot(m.emotion)
}
}
\references{
Tutz, Gerhard, Schauberger, Gunther and Berger, Moritz (2018): 
Response Styles in the Partial Credit Model, \emph{Applied Psychological Measurement}, \url{https://journals.sagepub.com/doi/10.1177/0146621617748322}
}
\seealso{
\code{\link{PCMRS}}, \code{\link{person.posterior}}, \code{\link{tenseness}}, \code{\link{emotion}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}\cr
\url{https://www.sg.tum.de/epidemiologie/team/schauberger/}
}
\keyword{Credit}
\keyword{PCMRS}
\keyword{Partial}
\keyword{Response}
\keyword{Style}
\keyword{package}
