% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMRS.R
\name{PCMRS}
\alias{PCMRS}
\title{Model Response Styles in Partial Credit Models}
\usage{
PCMRS(Y, Q = 10, scaled = TRUE, method = c("L-BFGS-B", "nlminb"),
  cores = 30)
}
\arguments{
\item{Y}{Data frame containing the ordinal item response data (as ordered factors), one row per obeservation, one column per item.}

\item{Q}{Number of nodes to be used (per dimension) in two-dimensional Gauss-Hermite-Quadrature.}

\item{scaled}{Should the scaled version of the response style parameterization be used? Default is \code{TRUE}.}

\item{method}{Specifies optimization algorithm used by \code{\link{optim}}, either 
\code{L-BFGS-B} or \code{nlminb}.}

\item{cores}{Number of cores to be used in parallelized computation.}
}
\value{
\item{delta}{Matrix containing all item parameters for the PCMRS model, one row
per item, one column per category.} 
\item{Sigma}{2*2 covariance matrix for both random effects, namely the ability parameters theta and the
response style parameters gamma.}
\item{delta.PCM}{Matrix containing all item parameters for the simple PCM model, one row
per item, one column per category.} 
\item{sigma.PCM}{Estimate for variance of ability parameters theta in the simple PCM model.}
\item{Y}{Data frame containing the ordinal item response data, one row per obeservation, one column per item.} 
\item{scaled}{Logical, \code{TRUE} if scaled version of the response style parameterization is used.}
}
\description{
Performs PCMRS, a method to model response styles in Partial Credit Models
}
\examples{
\dontshow{
k <- 4; n <- 50; I <- 4
set.seed(1860)
Y <- as.data.frame(matrix(sample(1:k, I*n, TRUE),nrow = n))
Y <- data.frame(lapply(Y, as.ordered))

mini.ex <- PCMRS(Y, cores = 2)
mini.ex
}
\dontrun{
################################################
## Small example to illustrate model and person estimation
################################################

data(tenseness)

set.seed(1860)
samples <- sample(1:nrow(tenseness), 100)
tense_small <- tenseness[samples,1:4]

m_small <- PCMRS(tense_small, cores = 2)
m_small
plot(m_small)

persons <- person.posterior(m_small, cores = 2)
plot(jitter(persons,100))

################################################
## Example from Tutz et al. 2017:
################################################

data(emotion)
m.emotion <- PCMRS(emotion)
m.emotion

plot(m.emotion)
}
}
\references{
Tutz, Gerhard, Schauberger, Gunther and Berger, Moritz (2017): 
Response Styles in the Partial Credit Model, \emph{Applied Psychological Measurement}, to appear
}
\seealso{
\code{\link{person.posterior}} \code{\link{PCMRS-package}}
}
\author{
Gunther Schauberger\cr \email{gunther@stat.uni-muenchen.de}\cr
\url{https://tinyurl.com/gunther-lmu}
}
\keyword{PCMRS}
