% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMCreateLikelihood}
\alias{PCMCreateLikelihood}
\title{Create a likelhood function of a numerical vector parameter}
\usage{
PCMCreateLikelihood(X, tree, model, metaI = PCMInfo(X, tree, model),
  positiveValueGuard = Inf)
}
\arguments{
\item{X}{a \code{k x N} numerical matrix with possible \code{NA} and \code{NaN} entries. Each
column of X contains the measured trait values for one species (tip in tree).
Missing values can be either not-available (\code{NA}) or not existing (\code{NaN}).
Thse two values have are treated differently when calculating
likelihoods: see \code{\link{PCMPresentCoordinates}}.}

\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{metaI}{a list returned from a call to \code{PCMInfo(X, tree, model)},
containing meta-data such as N, M and k.}

\item{positiveValueGuard}{positive numerical value (default Inf), which serves as a guard for numerical error. Values exceeding
this positiveGuard are most likely due to numerical error and PCMOptions()$PCMBase.Value.NA is returned instead.}
}
\value{
a function of a numerical vector parameter called p returning the likelihood
of X given the tree and the model with parameter values specified by p.
}
\description{
Create a likelhood function of a numerical vector parameter
}
\details{
It is possible to specify a function for the argument metaI. This function should
have three parameters (X, tree, model) and should return a metaInfo object. (see \code{\link{PCMInfo}}).
}
