% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixedGaussian.R
\name{MixedGaussian}
\alias{MixedGaussian}
\title{Create a multi-regime Gaussian model (MixedGaussian)}
\usage{
MixedGaussian(k, modelTypes, mapping,
  className = paste0("MixedGaussian_", do.call(paste0,
  as.list(mapping))), X0 = structure(0, class = c("VectorParameter",
  "_Global"), description = "trait values at the root"), ...,
  Sigmae_x = structure(0, class = c("MatrixParameter",
  "_UpperTriangularWithDiagonal", "_WithNonNegativeDiagonal", "_Global"),
  description =
  "Upper triangular Choleski factor of the non-phylogenetic variance-covariance"))
}
\arguments{
\item{k}{integer defining the number of traits.}

\item{modelTypes}{a character string vector with the class names of the
model-types that can possibly be included (assigned to regimes) in the MixedGaussian,
e.g. c("BM", "OU") (see also \code{\link{PCMModels}}).}

\item{mapping}{a character string vector with elements from modelTypes or an
integer vector with elements between 1 and length(modelTypes)
mapping modelTypes to regimes, e.g. if \code{modelTypes = c("BM", "OU")} and
\code{mapping = c(a = 1, b = 1, c = 2, d = 1)} defines an MixedGaussian with four
different regimes with model-types BM3, BM3, OU3 and BM3, corresponding to each
regime. \code{mapping} does not have to be a named vector. If it is a named
vector, then all the names must correspond to valid regime names in a tree to
which the model will be fit or simulated (member tree$edge.regime should be a
character vector). If it is not a named vector then the positions of the
elements correspond to the regimes in their order given by the function
\code{\link{PCMTreeUniqueRegimes}} called on a tree object.}

\item{className}{a character string definingn a valid S3 class name for the
resulting MixedGaussian object. If not specified, a className is generated using the
expression \code{ paste0("MixedGaussian_", do.call(paste0, as.list(mapping)))}.}

\item{X0}{specification for the global vector X0 to be used by all
models in the MixedGaussian.}

\item{...}{specifications for other _Global parameters coming after X0.}

\item{Sigmae_x}{sepcification of a _Global Sigmae_x parameter. This is used
by Submodels only if they have Sigmae_x _Omitted.}
}
\value{
an object of S3 class className inheriting from MixedGaussian, GaussianPCM and
PCM.
}
\description{
Create a multi-regime Gaussian model (MixedGaussian)
}
\details{
If X0 is not NULL it has no sense to use model-types including X0 as a
parameter (e.g. use BM1 or BM3 insted of BM or BM2). Similarly if Sigmae_x is
not NULL there is no meaning in using model-types including Sigmae_x as a
parameter, (e.g. use OU2 or OU3 instead of OU or OU1).
}
\seealso{
\code{\link{PCMTreeUniqueRegimes}}

\code{\link{PCMModels}()}
}
