% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeListRootPaths}
\alias{PCMTreeListRootPaths}
\title{A list of the path to the root from each node in a tree}
\usage{
PCMTreeListRootPaths(tree, tableAncestors = PCMTreeTableAncestors(tree))
}
\arguments{
\item{tree}{a phylo object}

\item{tableAncestors}{an integer matrix resulting from a call to
PCMTreeTableAncestors(tree).}
}
\value{
a list with unnamed elements in the order of nodes in the tree. Each
element is an integer vector containing the ancestors nodes on the path from
the node (i) to the root of the tree in that order (the first element in the
 vector is the parent node of i and so on).
}
\description{
A list of the path to the root from each node in a tree
}
\details{
This function has time and memory complexity O(M^2), where M is the
 number of nodes in the tree. It can take several minutes and gigabytes of
 memory on trees of more than 10000 tips.
}
