% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgainStart.R
\docType{data}
\name{HARDWATER}
\alias{HARDWATER}
\title{Mortality and Water Hardness}
\format{A data frame with 61 observations on the following 4 variables: 
\itemize{
\item \code{location} (a factor with levels \code{North} and \code{South} indicating whether the town is as far north as Derby or further)
\item \code{town} (the name of the town)
\item \code{mortality} (average annual mortality per 100,000 males)
\item \code{hardness} (calcium concentration (in parts per million))
}}
\source{
D. J. Hand, F. Daly, A. D. Lunn, K. J. McConway and E. Ostrowski. 1994. \emph{A Handbook of Small Datasets}. Chapman and Hall/CRC, London.
}
\usage{
HARDWATER
}
\description{
Mortality and drinking water hardness for 61 cities in England and Wales
}
\details{
These data were collected in an investigation of environmental causes of disease.  They show the annual mortality rate per 100,000 for males, averaged over the years 1958-1964, and the calcium concentration (in parts per million) in the drinking water supply for 61 large towns in England and Wales.  (The higher the calcium concentration, the harder the water.)
}
\examples{
ggplot(data = HARDWATER, aes(x = hardness, y = mortality, color  = location)) + 
geom_point() + labs(y = "averaged annual mortality per 100,000 males", 
x = "calcium concentration (in parts per million)")
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}

